<?php
require_once "./class_dbase.php";

$mem_sel_find = (isset($_GET['MSF']))? $_GET['MSF'] : 'dest';
$mem_inp_find = (isset($_GET['MIF']))? $_GET['MIF'] : '';
$mem_found = (isset($_GET['FV']))? $_GET['FV'] : '';


$ar_nn = array('FS','FD','V1','V2','V3','V4','V5','V6','V7','V8','V9');
$ar_xh = array();
$ar_bp = array();
if(isset($_GET['FS']))
{
    // header, find, or next/prev caused a reload
    foreach($ar_nn as $n)
    {
        $ar_bp[$n] = (!isset($_GET[$n]))? 1 : $_GET[$n];
    }
    file_put_contents('./bpmem.txt', serialize($ar_bp));
}
else
{
    // just now entered from Blueprint btn click
    $ar_bp = unserialize(file_get_contents('./bpmem.txt'));
}
//
foreach($ar_nn as $n)
{
    $ar_xh[$n] = ($ar_bp[$n] == 1)? '' : 'h_hide';
}

$TESTING = $_GET['TESTING'];
$VER = $_GET['VER'];
$PERPAGE = $_GET['PERPAGE'];
$XZ = $_GET['XZ'];
$CS = $_GET['CS']; // 1=pageless silos, 0=none
$LINES = $_GET['LINES'];
$FELINES = $_GET['FELINES'];
$FDEF = $_GET['FDEF'];
$FSILO = $_GET['FSILO'];
$FINDEX = $_GET['FINDEX'];
$FEXT = $_GET['FEXT'];
$iInB = $_GET['iInB']; // 1=show page in browser tab, 0=separate browser
$bpTime = $_GET['bpTime'];
$slash_yn = $_GET['slash_yn'];
$b_slash = ($slash_yn == 'yes');

$xCityinfo = $_GET['xCityinfo'];
$int_ascZip = $_GET['int_ascZip'];
$int_xMultitem = $_GET['int_xMultitem'];
$int_ascGeo = $_GET['int_ascGeo'];
$int_bNoFront = $_GET['int_bNoFront'];

if($TESTING == 1)
{
    $ht_button = '../cssfiles/button.css';
    $xGGcf5Xb0  = '../jsfiles/viewer.js';
    $ht_sbcss = '../cssfiles/shadowbox.css';
    $ht_sbjs  = '../jsfiles/shadowbox.js';
}
else
{
    $ht_button ="css/mpc.button.$VER.min.css";
    $xGGcf5Xb0 = "js/mpc.viewer.$VER.min.js";
    $ht_sbcss = "css/mpc.sbox.$VER.min.css";
    $ht_sbjs  = "js/mpc.sbox.$VER.min.js";
}

// set curr/next/prev button q values
if($LINES < $PERPAGE)
{
    // single page
    $iPages = 1;
    $currPage = 0;
    $nextPage = 0;
    $prevPage = 0;
}
else
{
    // multi pages
    $iPages = floor( ($LINES + $PERPAGE)/$PERPAGE ); // 2-x
    $currPage = (isset($_GET['currPage']))? $_GET['currPage'] : 0;
    $prevPage = $currPage -1;
    if($prevPage < 0) $prevPage = $iPages -1;
    $nextPage = $currPage + 1;
    if($nextPage >= $iPages) $nextPage = 0;
}
$qs  = "&TESTING=$TESTING&VER=$VER&PERPAGE=$PERPAGE&XZ=0&CS=$CS&LINES=$LINES&FELINES=$FELINES&FDEF=$FDEF&FSILO=$FSILO";
$qs .= "&FINDEX=$FINDEX&FEXT=$FEXT&iInB=$iInB&bpTime=$bpTime&slash_yn=$slash_yn";
$qs .= "&xCityinfo=$xCityinfo";
$qs .= "&int_xMultitem=$int_xMultitem";
$qs .= "&int_ascZip=$int_ascZip";
$qs .= "&int_ascGeo=$int_ascGeo";
$qs .= "&int_bNoFront=$int_bNoFront";


// dump a screenful of html-bp lines --> bx.txt file
$dbBlue = new dbase('.', 'bh.db');
$retjson = $dbBlue->dumpBpPagesH($currPage, $currPage, 'bx.txt', $PERPAGE);
$rj = json_decode($retjson);
$yb1d40XxF = $rj->varcount;
$iLegend = ( ($ar_xh['FS'] == '') && ($ar_xh['FD'] == '') )? $rj->iLegend : 0;

//$iLegend = $rj->iLegend;

$vc3 = $yb1d40XxF+3;
$vlab = array_fill(0,8,' ');
for($x=1;$x<$yb1d40XxF;$x++)
{
    $vn = (! file_exists('snap/cp_txVar'.$x))? '' :  file_get_contents('snap/cp_txVar'.$x);
    if($vn != '')
    {
        $vlab[$x-1] = $vn;
        continue;
    }
    if( file_exists('snap/cp_txVar'.$x) && (filesize('snap/cp_taVar'.$x) > 0) )
    {
        $vlab[$x-1] = 'var'.$x;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8" />
<title>MPC - Blueprint</title>
<link  href="<?php echo $ht_button ?>" rel="stylesheet" type="text/css" />
<link rel="icon" type="image/png" href="images/favicon16.png" sizes="16x16">
<link rel="icon" type="image/png" href="images/favicon32.png" sizes="32x32">
<script src="<?php echo $xGGcf5Xb0 ?>"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js" ></script>
<link  href="<?php echo $ht_sbcss ?>" rel="stylesheet" type="text/css" />
<script src="<?php echo $ht_sbjs ?>"></script>
<script>Shadowbox.init({animateFade:0,modal:true,enableKeys:false});</script>

<style type="text/css">
body {
    font-family:monospace;
    font-size:12.8px;
    margin:0;
    padding:0;
    color:black;
    background-color:white;
}
.tshad {
    text-shadow:1px 1px black;
}
a, a:link, a:visited {color:blue;text-decoration:none;}
a:hover {text-decoration:underline}
td {text-align:left;padding:0;white-space:nowrap;}

.h_hide {
    color:white;
    background-color:#c00000;
}


#h_dst:hover, #h_src:hover, #h_var1:hover, #h_var2:hover, #h_var3:hover, #h_var4:hover,
#h_var5:hover, #h_var6:hover, #h_var7:hover, #h_var8:hover, #h_var9:hover {
    background-color:#627aad;
    color:white;
}

/* colors */
.defi {background-color:#cbf0a6; }
#defi:hover {color:#cbf0a6;background-color:#3a3a3a; }

.fronti, #fronti { background-color:#ffC966; }
.frontb { background:rgba(255,201,102, 0.60) }
#fronti:hover { color:#ffc966;background-color:#3a3a3a; }

.siloi  { background-color:#ffec80; }
#siloi:hover { color:#ffec80;background-color:#3a3a3a; }

.indexi { background-color:#b8e8ff; }
.indexb { background:rgba(184,232,255, 0.60) }
#indexi:hover { color:#b8e8ff;background-color:#3a3a3a; }

.exti { background-color:#f0f0f0;color:#960096 }
#exti:hover { color:#f0f0f0;background-color:#960096; }
.ext   { color:#960096 }

.missingi {
    color:#c00000;
    font-weight: bold;
/*    background-color:#e0e0e0; */
}
.nosrc {
    color:#c00000;
    font-weight: bold;
}
/* legend */
.hd {
    font-family:Verdana,Arial,sans-serif;
    border-style:solid;
    border-color: #808080;
    padding:3px 5px;
    margin:0;
}

/* rounded corners */
.round-left {
    border-top-left-radius:5px;
    -moz-border-radius-topleft:5px;
    -webkit-top-left-border-radius:5px;
    border-bottom-left-radius:5px;
    -moz-border-radius-bottomleft:5px;
    -webkit-bottom-left-border-radius:5px;
}
.round-right {
    border-top-right-radius:5px;
    -moz-border-radius-topright:5px;
    -webkit-top-right-border-radius:5px;
    border-bottom-right-radius:5px;
    -moz-border-radius-bottomright:5px;
    -webkit-bottom-right-border-radius:5px;
}
.round-all {
    -moz-border-radius:5px;
    border-radius:5px;
    -webkit-border-radius:5px;
}
.found { background-color:pink }

/* borders */
.bw-tbl {border-width:1px 0 1px 1px }
.bw-all {border-width:1px }

.sexybutton {
    z-index:99;
}
.tb_num  {text-align:right;padding:1px 10px;width:20px}

.th     {text-align:left;  padding:0  2px;font-weight:bold;width:10px}
.thn    {text-align:right; padding:0 10px;font-weight:bold;width:10px}
.thx    {text-align:left;  padding:0 10px;font-weight:bold;height:48px}
.tb     {text-align:left;  padding:0  2px;width:10px}
.tbx    {text-align:left;  padding:0 10px}

.strike {
    opacity:0.3;
}

.odd {background-color:white}
.even {background-color:#f0f0f0}
.odd:hover, .even:hover {background-color:#b5d5ff}

.bg-public { background-color:pink !important }
.bg-google { background-color:lightgreen !important }


.noselect {
    -moz-user-select: -moz-none;
    -khtml-user-select: none;
    -webkit-user-select: none;
/*    cursor:default; */
}

select#sel_find {
    font-family:monospace;
    text-align:left;
    padding:2px 0;
    margin:0 0 0 15px;
    background:none;
    border:1px solid #808080;
    -moz-border-radius:5px;
    border-radius:5px;
    -webkit-border-radius:5px;
}

input#inp_find {
    font-family:monospace;
    width:250px;
    padding:3px 0 3px 4px;
    margin:0 2px 0 2px;
    background:none;
    border:1px solid #808080;
    -moz-border-radius:5px;
    border-radius:5px;
    -webkit-border-radius:5px;
}
.pink {background-color:pink !important}

.avis {
    white-space:nowrap;
    font-size:12.8px;
    font-family:verdana,Areal,Helvetica,sans-serif;
    margin-right:2px;
    padding:3px 5px;
    color:white;
    background-color:#627aad;
    border-radius:5px;
    -moz-border-radius:5px;
    -webkit-border-radius:5px;
    text-shadow: 1px 1px 0 #000000;
    cursor:default;
}
.avis:hover { background-color:#7e94bf !important; }

.busycss_bp {
  background:none;
  border: 4px solid transparent;
  border-radius: 50%;
  border-top: 4px solid #4388c7;
  border-bottom: 4px solid #4386c7;
  width:11px;
  height: 11px;
  -webkit-animation: spin 1s linear infinite;
  -moz-animation: spin 1s linear infinite;
  -ms-animation: spin 1s linear infinite;
  animation: spin 1s linear infinite;
}
@-webkit-keyframes spin {
  0% { -webkit-transform: rotate(0deg); }
  100% { -webkit-transform: rotate(360deg); }
}

@-moz-keyframes spin {
  0% { -moz-transform: rotate(0deg); }
  100% { -moz-transform: rotate(360deg); }
}

@-ms-keyframes spin {
  0% { -ms-transform: rotate(0deg); }
  100% { -ms-transform: rotate(360deg); }
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
</style>

<script>
var mem_csilo = {};
var xz = <?php echo $XZ ?>;
var cs = <?php echo $CS ?>;
var vc = <?php echo $yb1d40XxF ?>;
var iLegend = <?php echo $iLegend ?>;
var lines = <?php echo $LINES ?>;
var felines = <?php echo $FELINES ?>;
var fdef = <?php echo $FDEF ?>;
var fsilo = <?php echo $FSILO ?>;
var findex = <?php echo $FINDEX ?>;
var fext = <?php echo $FEXT ?>;
var mem_sel_find = '<?php echo $mem_sel_find ?>';
var mem_inp_find = '<?php echo $mem_inp_find ?>';
var mem_found = '<?php echo $mem_found ?>';
var perpage = <?php echo $PERPAGE ?>;
var iInB = <?php echo $iInB ?>;
var testing = <?php echo $TESTING ?>;
var ver = '<?php echo $VER ?>';

function deffind(q)
{
    gofind(q, 'line', fdef);
    return false;
}
function sifind(q)
{
    gofind(q, 'line', fsilo);
    return false;
}
function infind(q)
{
    gofind(q, 'line', findex);
    return false;
}
function exfind(q)
{
    gofind(q, 'line', fext);
    return false;
}
function fefind(q)
{
    var fe = 1 + Number(lines) - Number(felines);
    gofind(q, 'line', fe);
    return false;
}


function gofind(q, sel, inp)
{
    if(mem_found != '') jQuery('#ln'+mem_found).parent().parent().toggleClass('found', false);
    var j_inp_find = jQuery('#inp_find');
    var value, table;

    if(sel == '')
    {
        value = j_inp_find.val();
        value = value.trim();
        if(value == '')
        {
            j_inp_find.toggleClass('pink', true);
            j_inp_find.focus();
            return;
        }
        table = jQuery('#sel_find').val();
        if(sel != '') table = sel;
        if(table == 'line')
        {
            value = value.replace(/,/g, '');
            if( value.search(/[^0-9]/) != -1 ) return;
            if(value < 1) value = 1;
            if(value > lines) value = lines;
        }
    }
    else
    {
        table = sel;
        value = inp;
    }

    dim(); 
    jQuery.post('bpfind.php', { tbl:table, val:value, lines:lines },
        function(r)
        {
            j = jQuery.parseJSON(r);
            if(j.status == 'ng')
            {
                undim();
                j_inp_find.toggleClass('pink', true);
                j_inp_find.focus();
                return;
            }

            var newpage; 
            var newoffset; 
            if(j.value < perpage)
            {
                newpage = 0;
            }
            else
            {
                newpage = Math.floor(j.value/perpage);
            }
                newoffset = j.value - (newpage*perpage);

            var scrollto = (newoffset < 5)? '' : '#ln'+(j.value-5); 

            var v = '&FV='+j.value; 
            var r = '&RND='+j.rand;
            var x;
            var s;
            var z;
            z = (jQuery('#h_src').hasClass('h_hide'))? 0 : 1;
            s = '&FS='+z;
            z = (jQuery('#h_dst').hasClass('h_hide'))? 0 : 1;
            s += '&FD='+z;

            for(x=1;x<vc;x++)
            {
                z = (jQuery('#h_var'+x).hasClass('h_hide'))? 0 : 1;
                s += '&V'+x+'='+z;
            }
            var f = '&MSF='+jQuery('#sel_find').val()+'&MIF='+j_inp_find.val();
            location.href='viewerBH.php?currPage='+newpage+r+q+s+f+v+scrollto;
            undim();
        }
    );
}

function gopage(q)
{
    dim(); 
    var x;
    var s;
    var z;
    z = (jQuery('#h_src').hasClass('h_hide'))? 0 : 1;
    s = '&FS='+z;
    z = (jQuery('#h_dst').hasClass('h_hide'))? 0 : 1;
    s += '&FD='+z;
    for(x=1;x<vc;x++)
    {
        z = (jQuery('#h_var'+x).hasClass('h_hide'))? 0 : 1;
        s += '&V'+x+'='+z;
    }
    var f = '&MSF='+jQuery('#sel_find').val()+'&MIF='+jQuery('#inp_find').val();
    location.href='viewerBH.php?currPage='+q+s+f;
}

function showBusyBp()
{
    jQuery('#th_num').css('visibility', 'hidden');
    jQuery('#busy_bp').toggleClass('busycss_bp', true);
}
function hideBusyBp()
{
    jQuery('#busy_bp').toggleClass('busycss_bp', false);
    jQuery('#th_num').css('visibility', 'visible');
}

function dim()
{
    showBusyBp();
    jQuery('.pn' ).prop('disabled', true);
    jQuery('.pnc' ).prop('disabled', true);
    var j = jQuery('#sel_find');
    j.css('background', 'none');
    j.prop('disabled', true);
    j = jQuery('#inp_find');
    j.css('background', 'none');
    j.prop('disabled', true);
}

function undim()
{
    hideBusyBp();
    jQuery('.pn' ).prop('disabled', false);
    jQuery('.pnc' ).prop('disabled', false);
    var j = jQuery('#sel_find');
    j.css('background', 'white');
    j.prop('disabled', false);
    j = jQuery('#inp_find');
    j.css('background', 'white');
    j.prop('disabled', false);
}

/* display pageless silo list */
function listPageless()
{
    mem_csilo.height = jQuery(window).height()*.8;
    mem_csilo.width = 400;
    mem_csilo.top = 0;
    mem_csilo.left = 0;
    window.open('./lc.php', 'csilos', 'height='+mem_csilo.height+',width='+mem_csilo.width+',top='+mem_csilo.top+',left='+mem_csilo.left+',scrollbars=yes,resizable=yes');
}

/* Show list of missing Zipcodes */
function viewZip(inb, test, ver)
{
    if(inb == 1)
    {
        reportz = window.open('viewerZIP.php?TESTING='+test+'&VER='+ver);
    }
    else
    {
        reportz = window.open('viewerZIP.php?TESTING='+test+'&VER='+ver,
        'rept', 'height='+screen.availHeight*.9+', width='+screen.availWidth*.95+', scrollbars=yes,resizable=yes');
    }
    Shadowbox.close();
}

function geoWarnBox()
{
    var str = '';
    str += '<div style="font-size:12.8px;font-family:verdana,arial,helvetica,sans serif;margin:10px 10px 0 10px">';

    str += 'Some of the cities in your Project have no entry in the Mpc database.';
    str += '<br>';
    str += 'Cities can be added manually or you can request database additions.';

    str += '<div style="position:absolute;left:10px;bottom:20px">';

    str +=      '<button class="sexybutton" onclick="viewZip(iInB, testing, ver);return false">';
    str +=          '<span><span><span class="find">Show missing cities</span></span></span>';
    str +=      '</button>';
    str +=     '&nbsp;&nbsp;';

    str +=     '<button class="sexybutton" onclick="Shadowbox.close()"><span><span>';
    str +=     '<span class="cancel">Ignore</span></span></span></button>';
    str +=     '</div>';
    str += '</div>';

    Shadowbox.open(
    {
         content: str,
           title: '<span class="tshad">Unsupported Cities</span>',
          player: 'html',
  handleOversize: "none",modal: true,
         options: {animate:true, loadingColor:'gold', bodyColor:'gold'},
          height: 102,
           width: 485
    });
}

jQuery(document).ready(function() {
    var ar = new Array('num', 'src', 'dst');
    var j,x;
    for(x=0;x<3;x++)
    {
        j = jQuery('#th_'+ar[x]);
        j.css('width', j[0].getBoundingClientRect().width);
        jQuery('#tb_'+ar[x]+'1').css('width', j[0].getBoundingClientRect().width);
    }
    for(x=1;x<vc;x++)
    {
        j = jQuery('#th_var'+x);
        j.css('width', j[0].getBoundingClientRect().width);
        jQuery('#tb_var'+x).css('width', j[0].getBoundingClientRect().width);
    }
    jQuery('#tban').css('position', 'fixed');
    jQuery('#tpad').css('display', 'block');
    jQuery('.pnc' ).prop('disabled', false);

    var j = jQuery('#sel_find');
    j.css('background', 'white');
    j.prop('disabled', false);
    j = jQuery('#inp_find');
    j.css('background', 'white');
    j.prop('disabled', false);
    
    if(lines > (perpage-1)) jQuery('.pn' ).prop('disabled', false);
/*    jQuery('body' ).css('cursor', 'default'); */
    jQuery('#sel_find').val(mem_sel_find);
    jQuery('#inp_find').val(mem_inp_find);


    var oldScroll = 0;
    jQuery(function() {
        jQuery(window).scroll(function() {
            var hs = jQuery(window).scrollLeft();
            if(oldScroll != hs)
            {
                oldScroll = hs;
                jQuery('#tban').css('left', '-'+hs+'px');
                jQuery('#ctrl').css('left', '-'+hs+'px');
            }
        });
    });

    jQuery(function() {
        jQuery('.hc').click(function() {
            var j = jQuery('#'+this.id);
            if(j.hasClass('h_hide'))
            {
                j.toggleClass('h_hide', false);
            }
            else
            {
                j.toggleClass('h_hide', true);
            }
            gopage('<?php echo $currPage.$qs ?>');
        });
    });

    jQuery(function() {
        jQuery('#sel_find').change(function() {
            if(mem_found != '') jQuery('#ln'+mem_found).parent().parent().toggleClass('found', false);
        });
    });

    jQuery(function() {
        jQuery('#inp_find').click(function() {
            jQuery('#inp_find').toggleClass('pink', false);
            if(mem_found != '') jQuery('#ln'+mem_found).parent().parent().toggleClass('found', false);
        });
    });

    jQuery(function() {
        jQuery('#inp_find').keypress(function(e) {
            jQuery('#inp_find').toggleClass('pink', false);
            if(e.which == 13)
            {
                jQuery('#bnFind').click();
                return false;
            }
        });
    });

    jQuery(function() {
        jQuery('#inp_find').change(function() {
            jQuery('#inp_find').toggleClass('pink', false);
        });
    });

   jQuery(function() {
      jQuery('.vtr').mousedown(function(event) {
          if(event.which == 1)
          {
            jQuery('#'+this.id).toggleClass('bg-public', true);
          }
          else
          {
            jQuery('#'+this.id).toggleClass('bg-google', true);
          }
          return false;
      });
   });

   jQuery(function() {
      jQuery('.vtr').mouseout(function(event) {
          jQuery('#'+this.id).toggleClass('bg-public', false);
          jQuery('#'+this.id).toggleClass('bg-google', false);
          return false;
      });
   });

   jQuery(function() {
      jQuery('.vtr').mouseup(function(event) {
        jQuery('#'+this.id).toggleClass('bg-public', false);
        jQuery('#'+this.id).toggleClass('bg-google', false);
        MpcViewer.bpSel(this.id, event.which, iInB);
        return false;
      });
   });

    jQuery('#inp_find').focus();

    document.oncontextmenu = function(event) {
        if(event.preventDefault != undefined)
            event.preventDefault();
        if(event.stopPropagation != undefined)
            event.stopPropagation();
            return false;
    };
    hideBusyBp();

    /* any missing cities ? */
    if(xz == 1) setTimeout("geoWarnBox()",100);
});

</script>
</head>
<body class="noselect">
<!-- controls -->
<div id="ctrl" style="position:fixed;top:0;left:0;height:21px;width:497px;padding:5px 4px;background:none;z-index:99">
    <table>
        <tr>
            <td>
                &nbsp;<button class="sexybutton sexyicononly pn" disabled="disabled" title="Previous page of lines" onclick="gopage('<?php echo $prevPage.$qs ?>')">
                <span><span><span class="prev">&nbsp;</span></span></span></button>
            </td>
            <td>
                <div style="margin:0 2px">
                    <button class="sexybutton sexyicononly pn" disabled="disabled" title="Next page of lines" onclick="gopage('<?php echo $nextPage.$qs ?>')">
                    <span><span><span class="next">&nbsp;</span></span></span></button>
                </div>
            </td>
            <td>
                <button class="sexybutton pnc" disabled="disabled" title="Close listing" onclick="window.close();return false"><span><span><span
                class="cancel">Close</span></span></span></button>
            </td>

            <td>
                <select id="sel_find" disabled="disabled">
                    <option value="line" <?php if($mem_sel_find == 'line') echo 'selected' ?>>Line number</option>
                    <option value="src" <?php if($mem_sel_find == 'src') echo 'selected' ?>>Source</option>
                    <option value="dest" <?php if($mem_sel_find == 'dest') echo 'selected' ?>>Destination</option>
<?php
    for($x=1;$x<$yb1d40XxF;$x++)
    {
        if($vlab[$x-1] == '') continue; 
        $chk = ($mem_sel_find == "v$x")? 'selected' : '';
        echo '<option value="v'.$x.'" '.$chk.'>Var'.$x.': '.$vlab[$x-1].' </option>';
    }
?>
                </select>
            <td>

            <td><input id="inp_find" placeholder="search term" disabled="disabled" spellcheck="false" value="<?php echo $mem_inp_find ?>" /></td>

            <td>
                <button class="sexybutton pnc" id="bnFind" disabled="disabled" title="Find in Blueprint" onclick="gofind('<?php echo $qs ?>','','')"><span><span><span
                class="search">Find</span></span></span></button>
            </td>

            <td style="width:15px"><div style="width:15px"></div></td>

            <td><span onclick="deffind('<?php echo $qs ?>')" id="defi" class="defi hd round-left bw-tbl">default</span><span onclick="fefind('<?php echo $qs ?>')" id="fronti" class="hd bw-tbl">front</span><span onclick="sifind('<?php echo $qs ?>')" id="siloi" class="siloi hd bw-tbl">silo</span><span onclick="infind('<?php echo $qs ?>')" id="indexi" class="indexi hd bw-tbl">index</span><span onclick="exfind('<?php echo $qs ?>')" id="exti" class="exti hd round-right bw-all">ext</span></td>

<?php
    if($CS == 1)
    {
?>
        <td style="width:15px"><div style="width:15px"></div></td>
        <td>
            <div class="avis" onclick="listPageless()">List Pageless Silos</div>
        </td>
<?php
}
?>
            <td style="width:15px"><div style="width:15px"></div></td>
            <td><div><?php echo $bpTime ?></div></td>
        </tr>
    </table>
</div>

<div id="tpad" style="height:51px;width:100%;background-color:#c4c4c4;display:none">&nbsp;</div>

<div id="busy_bp" class="busycss_bp" style="position:absolute;top:30px;left:22px;z-index:99"></div>

<!-- thead -->
<table style="width:100%;text-align:left">
    <thead id="tban" style="position:auto;top:0;left:0;width:5000px;background-color:#c4c4c4">
    <tr>
        <td class="thn"><div id="th_num" style="visibility:hidden"><br><br><?php echo number_format($LINES) ?></div></td>
        <td class="th"><div id="th_src"><br><br><span id="h_src" class="hc <?php echo $ar_xh['FS'] ?>" title="show-hide Source">&nbsp;Source&nbsp;</span></div></td>
        <td class="th"><div id="th_dst"><br><br><span id="h_dst" class="hc <?php echo $ar_xh['FD'] ?>" title="show-hide Destination">&nbsp;Destination&nbsp;</span></div></td>
<?php
    for($x=1;$x<$yb1d40XxF;$x++)
    {
        echo '<td class="th"><div id="th_var'.$x.'"><br><span id="h_var'.$x.'" class="hc '.$ar_xh["V$x"].'" title="show-hide Var '.$x.'"><br>&nbsp;'.$vlab[$x-1].'&nbsp;</span></div></td>';
    }
?>
        <td class="thx">&nbsp;</td>
    </tr>
    <tr><td colspan="<?php echo $vc3 ?>"><div style="height:2px;width:5000px;border-bottom:1px solid #808080"></div></td></tr>
    </thead>

<!-- tbody -->
    <tbody style="font-weight:bold">
<?php
// open bx.txt and loop display each line
$xx2D3XA2F = fopen('./tmp/bx.txt', 'r');
$linecnt = ($currPage == 0)? 1 : 0;
$rownum = 1;
//
// loop thru page of lines
//
$found_num = (isset($_GET['FV']))? $_GET['FV'] : 0;
while(($line = fgets($xx2D3XA2F)) !== false)
{
    $bIsFront = false; // default not a [front] file
    $rn = $rownum; // 1-x
    $ar = explode("\t", trim($line)); // p, s, d, v0,v1...v9
    $rowclass = ($rownum++ & 1 == 1)?  'odd':'even';

    // number
    $n = $currPage*$PERPAGE+$linecnt++;
    $c = sprintf('%03d',$n);
    $fnd_class = ($c == $found_num)? 'found round-all' : '';

    if($n > 999) $c = number_format($c);

    // set row non-clickable if no source file (no silo index)
    $vtr = ($ar[1] == '__index__missing')? '' : 'vtr';

    echo '<tr class="'.$rowclass.' '.$vtr.'" id="tr'.$n.'">';
    echo '<td class="tb_num '.$fnd_class.'"><div id="tb_num'.$rn.'"><div id="ln'.$n.'">'.$c.'</div></div></td>';

    $bh_def = '';
    
    // source
    if($ar_xh['FS'] == 'h_hide')
    {
        $s = '';
    }
    else
    {
        // check if missing silo index file
        if($ar[1] == '__index__missing')
        {
            // missing silo-index, so missing source
            $bh_def = 'nosrc round-all';
            $s = 'NO SOURCE';
        }
        else
        {
            // color if default source
            $xF0F1beXf = substr($ar[2], -2);
            $bh_def = ( ($xF0F1beXf == '_(') || ($xF0F1beXf == '_)') )? 'defi round-all' : '';
            $s = $ar[1];
        }
    }
    if($rn == 1) echo '<td class="tb"><div id="tb_src1" class="bh_src '.$bh_def.'">&nbsp;'.$s.'&nbsp;</div></td>';
    else         echo '<td class="tb"><div class="bh_src '.$bh_def.'">&nbsp;'.$s.'&nbsp;</div></td>';

    // destination
    if($ar_xh['FD'] == 'h_hide')
    {
        $d = '';
    }
    else
    {
        $_path = str_replace('//', "\t", $ar[0]); // colorize path
        $_path = preg_replace('#(\S+)\t#', '<span class="siloi round-all">&nbsp;$1&nbsp;</span>/', $_path);
        $d = $ar[2];
        switch(substr($d, -2))
        {
            case '_#': // ext
            case '_)': // [default] ext
                $d = substr($d, 0, -2);
                $d = trim($_path,'/').'<span class="ext">'.$d.'&nbsp;</span>';
                break;
            case '_@': // silo index?
                $d = substr($d, 0, -2);
                if($d == '__index__missing') $d = $_path.'<span class="missingi round-all">&nbsp;NO INDEX&nbsp;</span>';
                else if(! $b_slash) $d = $_path.'<span class="indexi round-all">&nbsp;'.$d.'&nbsp;</span>';
                else $d = $_path.'<span class="indexi indexb round-all">&nbsp;<span class="strike">'.$d.'</span>&nbsp;</span>';
                break;
            case '_!': // [front]
                $bIsFront = true; // flag it's a [front] file
                if( $b_slash && (preg_match('/(.*?)(\A|\/)(index.(?:php|html|htm))$/', $ar[0], $m) == 1) ) {
                    $d = '<span class="fronti frontb round-all">&nbsp;'.$m[1].$m[2].'<span class="strike">'.$m[3].'</span>&nbsp;</span>';
                }else{
                    $d = '<span class="fronti round-all">&nbsp;'.$ar[0].'&nbsp;</span>';
                }
                break;
            case '_(': // [default] file?
                $d = substr($d, 0, -2);
                if( $b_slash && (preg_match('/(.*?)(\A|\/)(index.(?:php|html|htm))$/', $d, $m) == 1) )
                {
                    $d = $m[1].$m[2].'<span class="strike">'.$m[3].'</span>';
                }
                $d = trim($_path,'/').'/'.$d;
                break;
            default: // regular file
                if( $b_slash && (preg_match('/(.*?)(\A|\/)(index.(?:php|html|htm))$/', $d, $m) == 1) )
                {
                    $d = $m[1].$m[2].'<span class="strike">'.$m[3].'</span>';
                }
                $d = trim($_path,'/').'/'.$d;
                break;
        }
    }
    if($rn ==1) echo '<td class="tb bh_dst"><div id="tb_dst1">&nbsp;'.$d.'&nbsp;</div></td>';
    else        echo '<td class="tb bh_dst">&nbsp;'.$d.'&nbsp;</td>';
    
    // vars
    $s = array('<', '>');
    $r = array('&lt;', '&gt;');
    $ar_xMultitem = str_split($int_xMultitem);
    $ar_ascZip = array_reverse(str_split($int_ascZip));
    $ar_ascGeo = array_reverse(str_split($int_ascGeo));

    for($x=1;$x<$yb1d40XxF;$x++)
    {
        if( ($bIsFront && ($int_bNoFront & 0b1 << ($x-1))) || ($ar_xh["V$x"] == 'h_hide') )
        {
            $v = ''; // [front] hidden column
        }
        else
        {
            if($xCityinfo & 0b1 << ($x-1))
            {
                $v = '(city-info)';
            }
            else if($ar_ascZip[$x] != 0)
            {
                switch($ar_ascZip[$x])
                {
                    case 1:
                        $v = '(zip-spintax)';
                        break;
                    case 2:
                        $v = '(zip-list)';

                        break;
                    case 3:
                        $v = '(zip-multi)';
                        break;
                }
            }
            else if($ar_ascGeo[$x] == 1) $v = '(geo-multi)';
            else if($ar_xMultitem[$x] != 0)
            {
                $v = '(user-multi)'; // user multi.. 1=mi no formula line, 2=mi with [formula] lines
            }
            else
            {
                $v = $dbBlue->getVarValue($ar[$x+3]);
            }
            $v = str_replace($s, $r, $v);
        }
        if($rn == 1) echo '<td class="tb"><div id="tb_var'.$x.'">&nbsp;'.$v.'&nbsp;</div></td>';
        else         echo '<td class="tb">&nbsp;'.$v.'&nbsp;</td>';
    }
    
    // ending <td>
    echo '<td class="tbx">&nbsp;</td>';
    echo '</tr>';
}
echo '</tbody>';
echo '</table>';
fclose($xx2D3XA2F);
$dbBlue->close(false);
/*
function DEBUGV($msg,$file = './DEBUGV') {
    $xcf35XCFE = fopen($file,'ab');
    fwrite($xcf35XCFE,$msg,strlen($msg));
    fwrite($xcf35XCFE,"\n",1);
    fclose($xcf35XCFE);
}
function ARDEBUGV($msg,$xAC063X21,$file = './DEBUGV') {
    $msg .= "\n".print_r($xAC063X21,true);
    $xcf35XCFE = fopen($file,'ab');
    fwrite($xcf35XCFE,$msg,strlen($msg));
    fwrite($xcf35XCFE,"\n",1);
    fclose($xcf35XCFE);
}
*/
?>
</body>
</html>
