<?php
require_once('iccheck.php');
require_once 'table3.php';
require_once 'spin.php';
require 'glb.php';
//
define('x0dE1fXCF', 3);
define('yB4057Xbf',   0);
// 1-7 are canonical status
define('y3ED3cXF7',  10);
define('yx213dXa3', 11);
// spin_stat
define('SPIN_NONE', 0);
define('SPIN_NO',   1);

$ar_salem = array(
    'city_map' => "https://www.google.com/maps/place/Salem,+OR,+USA/@44.9329058,-123.1682908,11z/data=!3m1!4b1!4m5!3m4!1s0x54bffefcbc4b9c63:0xf93429e08f0357c2!8m2!3d44.9428975!4d-123.0350963",
    'city_blurb' => 'Salem is the capital city of Oregon. Set amid a park with gardens, the domed Oregon State Capitol contains a collection of art by Oregon artists. The Hallie Ford Museum of Art includes works by Pacific Northwest and Native American artists. The Willamette Heritage Center includes a Victorian wool mill, plus 19th-century homes with period furnishings. The Bush House Museum is an Italianate mansion built in 1878.',
    'city_latitude' => '44.9329058',
    'city_longitude' => '-123.1682908',
    'city_wikipedia' => 'http://en.wikipedia.org/wiki/Salem,_Oregon',
    'city_machine_id' => '/m/0d23k',
    'city_things_to_do' => 'https://www.google.com/travel/things-to-do?g2lb=2502548,2503771,2503781,4258168,4270442,4284970,4291517,4306835,4308227,4597339,4640247,4649665,4680677,4718357,4722435,4722900,4723331,4733969&hl=en-BD&gl=bd&ssta=1&dest_mid=/m/0d23k&dest_state_type=main&dest_src=ts&q=Salem,%09Oregon&sa=X&ved=2ahUKEwi088WChKD3AhW14zgGHTc0Ax0QuL0BegQIbBAv',

    'state_flag' => ' ',
    'state_seal' => ' ',
    'state_website' => 'https://www.oregon.gov/',
    'state_map' => 'https://www.google.com/maps/place/Oregon/@44.1273348,-122.832062,7z/data=!3m1!4b1!4m5!3m4!1s0x54936e7c9b9f6a55:0x7d4c65db7a0bb876!8m2!3d43.8041334!4d-120.5542012',
    'state_blurb' => "Oregon is a state in the Pacific Northwest region of the Western United States. The Columbia River delineates much of Oregon's northern boundary with Washington, while the Snake River delineates much of its eastern boundary with Idaho. The 42nd north parallel delineates the southern boundary with California and Nevada.",
    'state_latitude' => '44.1273348',
    'state_longitude' => '-122.832062',
    'state_wikipedia' => 'https://en.wikipedia.org/wiki/Oregon',
    'state_machine_id' => '/m/05kj_',
    'state_things_to_do' => 'https://www.google.com/travel/things-to-do?g2lb=2502548,2503771,2503781,4258168,4270442,4284970,4291517,4306835,4308226,4401769,4429192,4597339,4640247,4647135,4649665,4680677,4722435,4722900,4723331,4726607,4733968,4736008,4738606,4741665,4742276&hl=en-PH&gl=ph&ssta=1&dest_mid=/m/05kj_&dest_state_type=main&dest_src=ts&q=Oregon+things+to+do&sa=X&ved=2ahUKEwiukpvrj-72AhVCa94KHftgCiEQuL0BegQIBBA7'
);

/******************************************
 *
 * Make a temp htm file for [Preview] or
 *   Process [404]
 *
 * ----------------------------------
 *   tag = 'bn404' .. bn404 clicked
 *     DATA64 ....... <editor buffer> (my_base64 encoded)
 *     scanType ..... 'assf', 'webr', 'extf' (support files location)
 *     websub ....... 'optional subfolder for Scan404
 *     assetFolder .. '/mpc/subdir/'
 *
 * ----------------------------------
 *   tag = 'bnPre' .. bnPreview clicked
 *     FILE ..... a.htm (or p.htm)
 *     DATA64 ... <editor buffer> (my_base64 encoded)
 *     varNine .. <9 vars> (my_base64 encoded)
 * ----------------------------------
 *   tag = 'respin' .. bnRespin clicked
 *     FILE .... a.htm (or p.htm)
 *     WPHH .... 'px' ignore (not wp article)
 *          .... '??px' current height of wphead div
 *
 *     returns a random number
 * ----------------------------------
 *
 * Exit: error msg or:
 *       ok .. no warnings or errors
 *     okbr .. had spintax brace error
 *     okns .. had spintax nospin warning
 */

$file = (isset($_GET['FILE']))? $_GET['FILE'] : ""; // 'a.htm' or 'p.htm'
$WPHH = (isset($_GET['WPHH']))? $_GET['WPHH'] : 'px';
$tmpfile = 'tmp.'.$file; // 'tmp.a.htm' or 'tmp.p.htm'
$rawfile = 'raw.'.$file; // 'raw.a.htm' or 'raw.p.htm'

// process inputs
$tag = $_GET['tag'];

// globals
$yXdB86X29 = yB4057Xbf;
$y2c53aXEa = 'ok'; // return status
$xEG154XF3 = "";
$xx213dXa3 = "";
$x3ED3cXF7 = "";
$Project;

switch($tag)
{
    //----------------------------
    case 'respin':
    //----------------------------
        $bArticle = ($rawfile == 'raw.a.htm');
        create_db($rawfile); // create preview db with random seed_pg
        $VER = $_POST['VER'];
        $TESTING = $_POST['TESTING'];
        try {
            xeA512X03('file:preview.db?immutable=1');
        }
        catch(Exception $e) {
            if($e->getMessage() == 't');
            {
                $xF8598X1F  = '<div style="font-family:verdana,arial,sans-serif">';
                $xF8598X1F .= '<h3>Session Expired. More than 24 hours have elapsed since logging in.</h3>';
                $xF8598X1F .= 'Please follow these steps to start a new Mpc session:';
                $xF8598X1F .= '<ol>';
                $xF8598X1F .= '<li>Close this Preview.</li>';
                $xF8598X1F .= '<li>Save Source file as needed.</li>';
                $xF8598X1F .= '<li>Close the Editor</li>';
                $xF8598X1F .= '<li>Click the \'Log Out\' link to restart Mpc.</li>';
                $xF8598X1F .= '</ol>';
                $xF8598X1F .= '</div>';
                break;
            }
        }
        $xF8598X1F = file_get_contents('dst.x.htm'); // spun and braces restored
        break;
    //----------------------------
    case 'bn404': // bn404 clicked
    //----------------------------
        do404(); // no return.. function exits
        break;

    //----------------------------
    case 'bnPre': // bnPreview clicked
    //----------------------------
        $bArticle = ($rawfile == 'raw.a.htm');
        $WPHH = '68px'; // default for wphead div height (for wp article)
        if(file_exists($rawfile)) unlink($rawfile);
        $VER = $_POST['VER'];
        $webRoot = $_POST['webRoot']; // 0,1
        $TESTING = $_POST['TESTING'];
        $Project = json_decode(file_get_contents('jsettings')); // decode as Object
        $xF8598X1F = base64_decode( str_replace( array('-','_','.'),array('+','/','='), $_POST['DATA64'] ) );
        $postV9 = base64_decode( str_replace( array('-','_','.'),array('+','/','='), $_POST['varNine'] ) );
        $obj = json_decode($postV9, false);
        $arVarNine = $obj->v9;
        $arVarNineN = $obj->n9;

        if( ($xF8598X1F != "") && ($webRoot != 1) )
        {
            // if wp article, decode json wpinstructions to [key]value[key] format
            if($bArticle)
            {
                if(preg_match('!\[MPC_WPINSTRUCTIONS\](.*?)\[/MPC_WPINSTRUCTIONS\](?:\<br \/\>)?(.*)!si', $xF8598X1F, $m) != 1)
                {
                    // wp instructions not found
                }
                else
                {
                    // decode wpinst json and format to top of $xF8598X1F as [key]value[key]
                    $pos1 = strpos($m[1], '{');
                    $pos2 = strrpos($m[1], '}');
                    $jwpi = substr($m[1], $pos1, ($pos2-$pos1)+1);
                    $ar_wpinst = json_decode($jwpi, true);
                    $xF8598X1F = '[nospin]'; // nospin the entire wp instructions area.
                    foreach($ar_wpinst as $k=>$v)
                    {
                        if($k == 'wphead')
                        {
                            $s = array('&lt;', '&gt;');
                            $r = array('<', '>');
                            $v = str_replace($s, $r, $v);
                        }
                        $xF8598X1F .= "[mpc_wp_$k]";
                        $xF8598X1F .= $v;
                        $xF8598X1F .= "[mpc_wp_$k]\n";
                    }
                    $xF8598X1F .= '[/nospin]';
                    $xF8598X1F .= "[mpc_wp_content]$m[2][mpc_wp_content]";
                }
            }

            // 
            // check for canonicals
            // 
            //   skip if a [front] file is being edited
            // 
            $zz = file_get_contents('./isfront.php');
            if($zz == 0)
            {
                $yXdB86X29 = statCanonical();
                {
                    if($yXdB86X29 != 0)
                    {
                        // found  canonical (or shortlink or og:url)
                        $y2c53aXEa = 'okns';
                        break;
                    }
                }
            }
            $xF8598X1F = str_replace('/#url!:h#', '#', $xF8598X1F);
            //
            // replace vars in source file
            //
            $vlab = getVarLabels(); // get cust var labels
            xC2E8eXa9($vlab, $xF8598X1F);     // convert #varN# --> #var00# thru #var=09:a#

            // put vars --> arBlueline
            $x3ED3cXF7 = array_fill(0,10,' ');
            for($x=0;$x<9;$x++)
            {
                $x3ED3cXF7[x0dE1fXCF+1+$x] = $arVarNine[$x];
            }                   
            ycAc83X77($xF8598X1F); // replace #vars#

            //
            //  surround <style> and <script> areas with [xospin]
            //    callback will put [xospin]'s if braces found inside tags
            //
            $xF8598X1F = preg_replace_callback('/\<(style|script)\b[^\>]*?>.*?\<\/\\1\>/is', '_set_xospinCback', $xF8598X1F); //<?

            //
            // removed nested nospins
            //
            $spin_stat = SPIN_NONE;
            $xspin_stat = ''; // value for closing <style> or <script> area
            $xF8598X1F = preg_replace_callback('/(?:\<!-- ?)?(\[\/?[ndx]ospin\])(?: ?--\>)?/i', '_fix_nospinCback', $xF8598X1F);
            if($spin_stat != SPIN_NONE) $xF8598X1F .= '[/nospin]';

            //
            // replace srcfile smart constants
            //
            $s = array(
                '/!domain-url!/',   // http(s)://www.domain.com
                '/!project-url!/',  // http(s)://www.domain.com/mpcfolder/prjfolder
                '/!project-path!/', // /home/user/public_html/mpc/projectf
                '/!webroot-path!/'  // /home/user/public_html
            );
            $r = array(
                $obj->domurl, // from 'current' server
                $obj->pfurl,
                $obj->pfurl, // can't use local 'paths' because in an Iframe
                $obj->domurl
            );
            $xF8598X1F = preg_replace($s,$r,$xF8598X1F);

            //
            // process shortcodes
            //
//            $xF8598X1F = preg_replace_callback('/\[\s*mpc-shortcode:\s*youtube\s+(\{.+?\})\s*\]/i', '_youtubeCback', $xF8598X1F);
            $xF8598X1F = preg_replace_callback('/\[\s*mpc-(?:widget|shortcode):\s*(?:front_)?silo_table\s+(.+?)\s*\]/i', '_silotableCback', $xF8598X1F);
            $xF8598X1F = preg_replace_callback('/\[\s*mpc-widget:\s*related_links_table\s+(.+?)\s*\]/i', '_rlinksCback', $xF8598X1F);
            $xF8598X1F =          preg_replace('/\[\s*mpc-shortcode:\s*(var_redir|redir|var_overlay|overlay|var_dyna|dyna|cinc|cinc\d\d)\s*(\{.+?\})\s*\]/i', '', $xF8598X1F);

            //
            // validate braces
            //
            xDe9159X6(); // hide nospin braces
            if(xece7fXCC() != 0)
            {
                $yXdB86X29 = y3ED3cXF7; // found brace error
                restoreBraces(); // unhide protected braces
                $y2c53aXEa = 'okbr';
                break;
            }

            // braces valid .. save this Var-replaced/NOSPIN-protected file --> raw.p.htm (or raw.a.htm)
            file_put_contents($rawfile, $xF8598X1F);
            // check for possible missing NOSPINS (warning)
            if(isNoSpinWarning())
            {
                $yXdB86X29 = yx213dXa3; // found warning areas
                restoreBraces(); // unhide protected braces
                $y2c53aXEa = 'okns';
                break;
            }

            // ok to spin
            create_db($rawfile); // create preview.db
            try {
                xBaA11X6G('file:preview.db?immutable=1');
            }
            catch(Exception $e) {
                $emsg = $e->getMessage(); // 't' .. just gobble this up. 'Respin' btn will display the "over 24 hours warning".
            }
            $xF8598X1F = file_get_contents('dst.x.htm'); // spun and braces restored
        }
        break;
} // end switch(tag)

/**
 * create the preview.db
 */
function create_db($rawfile)
{
    if(file_exists('preview.db')) unlink('preview.db');
    $r = mt_rand(1,2000);
    $db = new SQLite3('preview.db');
    $db->exec('BEGIN TRANSACTION;');
    yXfx2dX23($db, 1, 0, 0, false, false, $r);
    $db->exec('COMMIT;');
    $db->exec('BEGIN TRANSACTION;');
    $db->exec("INSERT INTO source (id, path) VALUES (1, '$rawfile');");
    $db->exec("INSERT INTO page (id, src, dest, curr_var, prev_var, next_var, filter_id) VALUES (1, 1, 'dst.x.htm', 1, 1, 1, ".yebF1dXC9.");");
    $db->exec("INSERT INTO varset (id, num, var_id) VALUES (1, 1, 1);");
    $db->exec("INSERT INTO var (id, value) VALUES (1, '');");
    $db->exec('COMMIT;');
    $db->close();
}

if(($file=="")||($xF8598X1F=="")) 
{
    header('Content-type: text/html');
    echo '???';
    exit();
}
if($TESTING == 1)
{
    $ht_sbcss = '../cssfiles/shadowbox.css';
    $ht_sb    = '../jsfiles/pv.shadowbox.js';
}  
else
{  
    $ht_sbcss = "css/mpc.sbox.$VER.min.css";
    $ht_sb    = "js/pv.sbox.$VER.min.js";
}

/***************************************************************************************************************
 *
 * Create tmp HTML PAGE for Previewing
 *
 **************************************************************************************************************/
if(! $bArticle)
{
    // any spintax error or warning ?
    if($yXdB86X29 != yB4057Xbf)
    {
        // popStat:
        //       0 .. no warning or error
        //     1-7 .. canonical, shortlink, og:url
        //      10 .. brace error
        //      11 .. nospin warning
        

        // default 'spintax warning'
        $mpcBox = 'mpcWarnBox';
        $warnT = 'Spintax warning';
        $warnH = '305';
        $warnW = '550';
        $warnQ = 'nospin';
        $warnE = yx213dXa3;

        if ($yXdB86X29 < y3ED3cXF7)
        {
            // canonical error
            $warnT = 'Canonical links found';
            $warnQ = 'canon';
            $warnH = '243';
            $warnW = '550';
            $warnE = $yXdB86X29; // 1-7
        }

        if($yXdB86X29 == y3ED3cXF7) 
        {
            // brace error
            $mpcBox = 'mpcErrorBox';
            $warnE = y3ED3cXF7; // 10
        }

        if(preg_match("/(<head[^<]*?>)/i", $xF8598X1F, $m, PREG_OFFSET_CAPTURE) == 1) // <?
        {
            $pos = $m[1][1] + strlen($m[1][0]);

            // set <head> insert ==> $rstr
            $rstr  = "\n";
            $rstr .= "<link  href='$ht_sbcss' rel='stylesheet' />";
            $rstr .= "<script src='//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js'></script>";
            $rstr .= "<script>var jQuery_mpc = $.noConflict(true);</script>";
            $rstr .= "<script src='$ht_sb'></script>";
            $rstr .= '<script>';
            $rstr .=    "Shadowbox.init({animateFade:0,modal:true,enableKeys:false});";

            $rstr .=    "function mpcErrorBox(){";
            $rstr .=        "Shadowbox.open({";
            $rstr .=            "content: 'previewErr.php?ecnt=10&VER={$VER}&TESTING={$TESTING}',";
            $rstr .=            "title: 'Spintax error',";
            $rstr .=            "player: 'iframe',";
            $rstr .=            "handleOversize: 'none',";
            $rstr .=            "modal: true,";
            $rstr .=            "options:{animate:true, loadingColor:'pink', bodyColor:'pink'},";
            $rstr .=            "height: 126,";
            $rstr .=            "width: 550";
            $rstr .=        "});";
            $rstr .=    "}";

            $rstr .=    "function mpcWarnBox(){";
            $rstr .=        "Shadowbox.open({";
            $rstr .=            "content: 'previewErr.php?ecnt={$warnE}&VER={$VER}&TESTING={$TESTING}',";
            $rstr .=            "title:'$warnT',";
            $rstr .=            "player: 'iframe',";
            $rstr .=            "handleOversize: \"none\",";
            $rstr .=            "modal: true,";
            $rstr .=            "options:{qmarkTarget:'$warnQ', animate:true, loadingColor:'#c4c4c4', bodyColor:'#c4c4c4'},";
            $rstr .=            "height: $warnH,";
            $rstr .=            "width: $warnW";
            $rstr .=        "});";
            $rstr .=    "}";

            $rstr .=    "if(window.addEventListener) {window.addEventListener('load', $mpcBox, false);}";
            $rstr .=    "else if (window.attachEvent) {window.attachEvent('onload', $mpcBox);}";
            $rstr .=    "else {document.addEventListener('load', $mpcBox, false);} ";
            $rstr .= '</script>';
            $xF8598X1F = substr_replace($xF8598X1F,$rstr,$pos,0); // copy the above code --> <head> area
        }
    }

    // write as temp page file.. exit "ok"
    header('Content-type: text/html');
    $x6614XE05 = fopen($tmpfile, 'w'); // 'tmp.p.htm'
    if(!$x6614XE05)
    {
        echo 'open error. file='.$tmpfile;
        exit();
    }
    fwrite($x6614XE05,$xF8598X1F);
    fclose($x6614XE05);
    if($tag == 'respin')
    {
        echo mt_rand();
        exit();
    }
    echo $y2c53aXEa;
    exit();
} // End: Create tmp Html Page


/***************************************************************************************************************
 *
 * Create tmp WP-Source for Previewing
 *
 **************************************************************************************************************/
if($bArticle)
{
    $adivColor = 'white';
    $adivBack = '#008000';
    $adivMsg = "Everything below this line is Article Content";
    // parse article parts
    parseArticle($xF8598X1F, $arArticle);
    if($arArticle['status'] != 'ok')
    {
        switch($arArticle['status'])
        {
            // -----------------------------------
            case 'notitle':
            // -----------------------------------
                $rstr  = "<div class=\"iwarning\">";
                $rstr .= "This article does not have a properly configured Title.<br /><br />";
                $rstr .= "Instructions (from Mpc to the WP plugin) are placed at the beginning of articles. These Instructions are optional EXCEPT for the Title. The Title is REQUIRED.";
                $rstr .= "<br /><br />";
                $rstr .= "Follow these steps to correct the problem:";
                $rstr .= "<ol>";
                $rstr .= "<li>Using the Online Editor, righ-click and select 'Wordpress Instructions'.</li>";
                $rstr .= "<li>Enter a Title into the first input textbox.</li>";
                $rstr .= "<li>Click 'Write Instructions' and 'Close'.</li>";
                $rstr .= "<li>Click the 'Preview' button again to verify your corrections.</li>";
                $rstr .= "<li>Be sure to click 'Save Article' to make your changes permanent.</li>";
                $rstr .= "</ol>";
                $rstr .= "</div>";
                $arArticle['content'] = $rstr;
            break;

            // -----------------------------------
            case 'nbsp':
            // -----------------------------------
                $m = str_replace('&nbsp;', '<scan class="preview-dred">&amp;nbsp;</scan>', $arArticle['title']);

                $rstr  = "<div class=\"iwarning\">";
                $rstr .= "The article Title contains <b>html</b> entities for 'spaces'.";
                $rstr .= "<div class=\"preview-gray-box-div\">";
                $rstr .= "<span class=\"preview-gray-box\">$m</span>";
                $rstr .= "</div>";
                $rstr .= "The <b>html-spaces</b> need to be replaced with <b>text-space</b> characters.";
                $rstr .= " Follow these steps to correct the problem:";
                $rstr .= "<ol>";
                $rstr .= "<li>To make <b>html-spaces</b> visible, place the Online Editor into 'Source' mode (the 'Source' button turns blue).</li>";
                $rstr .= "<li>Replace all <span class=\"preview-boxr\">&amp;nbsp;</span> entities in the Title with a press of the Spacebar.</li>";
                $rstr .= "<li>Click 'Preview Article' again to verify your corrections.</li>";
                $rstr .= "<li>Be sure to click 'Save Article' to make your changes permanent.</li>";
                $rstr .= "</ol>";
                $rstr .= "</div>";
                $arArticle['content'] = $rstr;
            break;

            // -----------------------------------
            case 'htmltags':
            // -----------------------------------
            $t = $arArticle['title'];
            $xAE0118X8 = strlen($t);
            $m = "";
            for($x=0;$x<$xAE0118X8;$x++)
            {
                $c = substr($t,$x,1);
                if($c == '<')
                {
                    $m .= '<scan class="preview-dred">&lt;</scan>';
                    continue;
                }
                if($c == '>')
                {
                    $m .= '<scan class="preview-dred">&gt;</scan>';
                    continue;
                }
                $m .= $c;
            }
            $rstr  = "<div class=\"iwarning\">";
            $rstr .= "The article Title contains <b>html</b> tags.";
            $rstr .= "<div class=\"preview-gray-box-div\">";
            $rstr .= "<span class=\"preview-gray-box\">$m</span>";
            $rstr .= "</div>";
            $rstr .= "Titles must be <b>text only</b>. Html tags cannot be used.";
            $rstr .= "Follow these steps to correct the problem:";
            $rstr .= "<ol>";
            $rstr .= "<li>To make <b>html tags</b> visible, place the Online Editor into 'Source' mode (the 'Source' button turns blue).</li>";
            $rstr .= "<li>Remove all <span class=\"preview-boxr\">&lt;html tags&gt;</span>.</li>";
            $rstr .= "<li>Click 'Preview Article' again to verify your corrections.</li>";
            $rstr .= "<li>Be sure to click 'Save Article' to make your changes permanent.</li>";
            $rstr .= "</ol>";
            $rstr .= "If you want to include '&lt;' and '&gt;' brackets in your titles:";
            $rstr .= "<ul>";
            $rstr .= "<li>When the Online Editor is in 'Source' mode, type <scan class=\"preview-boxg\">&amplt;</scan> or <scan class=\"preview-boxg\">&ampgt;</scan>.";
            $rstr .= "<li>When the Online Editor is in 'Visual' mode, type <scan class=\"preview-boxg\">&lt;</scan> or <scan class=\"preview-boxg\">&gt;</scan>.";
            $rstr .= "</ul>";
            $rstr .= "</div>";
            $arArticle['content'] = $rstr;
            break;
        }
        // negate any spinmark problems (do not want popup to show)
        $yXdB86X29 = yB4057Xbf;
        $adivBack = '#d54e21';
        $adivColor = 'white';
        $adivMsg = "A problem has been found in the article Instruction lines";
    }

    //
    // Que up error or warning popup (if needed)
    //
    $onloadmsg = ""; // default no errors (for popup)

    // spintax error brace error?
    if($yXdB86X29 == y3ED3cXF7)
    {
        // braces unmatched
        $adivBack = '#d54e21';
        $adivColor = 'white';
        $adivMsg = "Spintax problem found. Unmatched braces";
        $onloadmsg = "onload=\"mpcErrorBox();return false\"";
    }
    elseif($yXdB86X29 != yB4057Xbf)
    {
        $onloadmsg = "onload='mpcWarnBox();return false'";
    }

    // head --> $xF8598X1F
    $rstr  = "<!DOCTYPE html>";
    $rstr .= "<html><head><title>Preview Article</title>";
    $rstr .= "<meta charset=\"utf-8\">\n";
    $rstr .= "<link  href=\"$ht_sbcss\" rel=\"stylesheet\" type=\"text/css\" />\n";
    $rstr .= "<style>";
    $rstr .= "html {overflow:scroll}";
    $rstr .= "body {margin:2px 0 0 0}";
    $rstr .= ".preview-cmd {white-space:nowrap;text-align:right;padding:2px 5px;margin-bottom:2px;background-color:white;}";
    $rstr .= ".preview-value {font-weight:normal;text-align:left;padding:2px 5px;margin-bottom:2px;white-space:normal;background-color:#e1f0fd;}";
    $rstr .= "#preview-divider {font-size:.8em;font-family: Verdana,Arial,Helvetica,sans-serif;font-weight:bold;margin:0 3px 10px 0;text-align:center;background-color:$adivBack;color:$adivColor;padding:4px 0;}";
    $rstr .= "#preview-prompt {font-size:.8em;font-family: Verdana,Arial,Helvetica,sans-serif;}";
    $rstr .= "#preview-prompt a:link, #preview-prompt a:visited {color:blue;text-decoration:none;}";
    $rstr .= "#preview-prompt a:hover {text-decoration:underline;}";
    $rstr .= "#preview-table {width:100%;}";
    $rstr .= ".preview-cmd-td {background-color:white;width:1%;}";
    $rstr .= ".preview-cmd8-td {text-align:left;font-size:12.8px;background-color:white}";
    $rstr .= ".preview-cmd8 {text-align:left;margin-top:5px;background-color:white}";
    $rstr .= ".preview-dred {color:#c00000;font-weight:bold}";
    $rstr .= ".preview-dgreen {color:#008000;font-weight:bold}";
    $rstr .= ".preview-boxr {color:#c00000;background-color:#f0f0f0;padding:0 2px;font-family:monospace;font-weight:bold}";
    $rstr .= ".preview-boxg {color:#008000;background-color:#f0f0f0;padding:0 2px;font-family:monospace;font-weight:bold}";
    $rstr .= ".preview-gray-box {padding:8px 0}";
    $rstr .= ".preview-gray-box-div {padding:8px 10px;margin:4px 0 20px;font-family:monospace;color:black;background-color:#f0f0f0;border:1px solid #808080}";
    $rstr .= ".iwarning {";
    $rstr .= "  font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12.8px;line-height:1.4em";
    $rstr .= "}";

    $rstr .= "#wpta_d {width:100%;height:52px;resize:none;overflow-y:scroll;background-color:#e1f0fd;border:2px solid #e1f0fd;box-sizing:border-box}";
    $rstr .= "#wpta_h {width:100%;height:100%;resize:none;overflow-y:scroll;background-color:#e1f0fd;border:2px solid #e1f0fd;box-sizing:border-box}";
    
    $rstr .= ".avis {font-size:11px;padding:3px 6px;margin-left:10px;color:white;background-color:#627aad;border-radius:5px;-moz-border-radius:5px;-webkit-border-radius:5px;cursor:default;text-shadow:1px 1px black}";
    $rstr .= ".avis:hover {background-color:#7e94bf}";
    $rstr .= "</style>\n";
    $rstr .= "<script src=\"//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js\" type=\"text/javascript\"></script>\n";
    $rstr .= "<script>var jQuery_mpc = $.noConflict(true);</script>";
    $rstr .= "<script src=\"$ht_sb\" type=\"text/javascript\"></script>";
    $rstr .= "<script type=\"text/javascript\">";
    $rstr .= "Shadowbox.init({animateFade:0,modal:true,enableKeys:false});\n";
    $rstr .= "function mpcErrorBox()\n";
    $rstr .= "{\n";
    $rstr .= "  Shadowbox.open({\n";
    $rstr .= "    content: 'previewErr.php?ecnt=1&VER={$VER}&TESTING={$TESTING}', title:'Spintax error',\n";
    $rstr .= "    player:     'iframe',\n";
    $rstr .= "   handleOversize: \"none\",\n";
    $rstr .= "   modal: true,\n";
    $rstr .= "   options:{animate:true,loadingColor:'pink',bodyColor:'pink'},\n";
    $rstr .= "      height:     100,\n";
    $rstr .= "      width:      550\n";
    $rstr .= "  });\n";
    $rstr .= "}\n";

    $rstr .= "function wph_expand(){\n";
    $rstr .= "var big = window.innerHeight-285;\n";
    $rstr .= "var el = document.getElementById('wpta_div');\n";
    $rstr .= "var h = (el.style.height != '68px')? '68px' : big+'px';\n";
    $rstr .= "el.style.height = h;\n";
    $rstr .= "}\n";

    $rstr .= "function mpcWarnBox()\n";
    $rstr .= "{\n";
    $rstr .= "  Shadowbox.open({\n";
    $rstr .= "    content: 'previewErr.php?ecnt=2&VER={$VER}&TESTING={$TESTING}', title:'Spintax warning',\n";
    $rstr .= "    player:     'iframe',\n";
    $rstr .= "   handleOversize: \"none\",\n";
    $rstr .= "   modal: true,\n";
    $rstr .= "   options:{qmarkTarget:'nospin',animate:true, loadingColor:'#c4c4c4', bodyColor:'#c4c4c4'},\n";
    $rstr .= "      height:     305,\n";
    $rstr .= "      width:      550\n";
    $rstr .= "  });\n";
    $rstr .= "}\n";
    $rstr .= "</script>";
    $rstr .= "</head>";
    $rstr .= "<body $onloadmsg>";
    $xF8598X1F = $rstr;

//    $noneMsg = '<span style="color:#800080;font-weight:bold">NONE</span>';
    $noneMsg = '&nbsp;';
    //
    // "title" ==> $xF8598X1F
    //
    $i = htmlspecialchars($arArticle['mpc_wp_title']);
    $xF8598X1F .= '<pre><table id="preview-table">';
    $xF8598X1F .= '<tr><td class="preview-cmd-td"><div class="preview-cmd">Title</div></td><td colspan="7"><div class="preview-value">'.$i.'&nbsp;</div></td></tr>';

    // "slug" ==> $xF8598X1F
    $i = trim($arArticle['mpc_wp_slug']);
    if($i == '') {
        $noU = '(None, using default): ';
        $i = strip_tags($arArticle['mpc_wp_title']);
    }else{
        $noU = '';
    }
    $i = strtolower(str_replace(' ', '-', $i));
    $xF8598X1F .= '<tr><td class="preview-cmd-td"><div class="preview-cmd">Slug</div></td><td colspan="7"><div class="preview-value">'.$noU.$i.'</div></td></tr>';

    $xF8598X1F .= '<tr>';

    // "tags" ==> $xF8598X1F
    $i = ($arArticle['mpc_wp_tags'] == '')? $noneMsg : $arArticle['mpc_wp_tags'];
    $xF8598X1F .= '<td class="preview-cmd-td"><div class="preview-cmd">Tags</div></td><td><div class="preview-value">'.$i.'</div></td>';

    // "parent" ==> $xF8598X1F
    $i = ($arArticle['mpc_wp_parent'] == '')? $noneMsg : str_replace(' ', '-', strtolower($arArticle['mpc_wp_parent']));
    $xF8598X1F .= '<td class="preview-cmd-td"><div class="preview-cmd">&nbsp;&nbsp;Parent</div></td><td><div class="preview-value">'.$i.'</div></td>';

    // "category" ==> $xF8598X1F
    $i = ($arArticle['mpc_wp_category'] == '')? $noneMsg : $arArticle['mpc_wp_category'];
    $xF8598X1F .= '<td class="preview-cmd-td"><div class="preview-cmd">&nbsp;&nbsp;&nbsp;Category</div></td><td><div class="preview-value">'.$i.'</div></td>';

    // "template" ==> $xF8598X1F
    $i = ($arArticle['mpc_wp_template'] == '')? $noneMsg : $arArticle['mpc_wp_template'];
    $xF8598X1F .= '<td class="preview-cmd-td"><div class="preview-cmd">&nbsp;&nbsp;&nbsp;Template</div></td><td><div class="preview-value">'.$i.'</div></td>';

    $xF8598X1F .= '</tr>';



    // meta description?
    $i = ($arArticle['mpc_wp_metadesc'] == '')? $noneMsg : $arArticle['mpc_wp_metadesc'];
    $xF8598X1F .= '<tr><td colspan="8" class="preview-cmd8-td"><div class="preview-cmd8">Meta Description</div></td></tr>';
    $xF8598X1F .= '<tr><td colspan="8"><div style="padding-left:0;height:82px;width:100%" class="preview-value"><textarea id="wpta_d" style="height:82px" rows="5">'.$i.'</textarea></div></td></tr>';

    // wp head?
    $i = ($arArticle['mpc_wp_wphead'] == '')? $noneMsg : htmlspecialchars($arArticle['mpc_wp_wphead']);
    $xF8598X1F .= '<tr>';
    $xF8598X1F .=    '<td colspan="8">';
    $xF8598X1F .=        '<table><tr>';
    $xF8598X1F .=            '<td class="preview-cmd8-td" style="vertical-align:top"><div class="preview-cmd8">WP Head</div></td>';
    $xF8598X1F .=            '<td><div class="avis" onclick="wph_expand()">EXPAND/COLLAPSE</div></td>';
    $xF8598X1F .=        '</tr></table>';
    $xF8598X1F .=    '</td>';

    $xF8598X1F .= '<tr><td colspan="8"><div id="wpta_div" style="padding-left:0;height:'.$WPHH.';width:100%" class="preview-value"><textarea spellcheck="false" id="wpta_h" rows="4">'.$i.'</textarea></div></td>';



    $xF8598X1F .= '</table></pre><div id="preview-divider">'.$adivMsg.'</div>';
    //
    // content ==> $xF8598X1F
    //
    $xF8598X1F .= '<div style="font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12.8px">'.$arArticle['mpc_wp_content'].'</div>';
    $xF8598X1F .= '</body></html>';
    // write as temp article file.. exit "ok"
    header('Content-type: text/html');
    $x6614XE05 = fopen($tmpfile, 'w'); // 'tmp.a.htm'
    if(!$x6614XE05)
    {
        echo 'open error. file='.$tmpfile;
        exit();
    }
    fwrite($x6614XE05,$xF8598X1F);
    fclose($x6614XE05);
    if($tag == 'respin')
    {
        echo mt_rand();
        exit();
    }
    echo $y2c53aXEa;
    exit();
} // End: Create tmp wp-source 


/////////////////////// Functions /////////////////////////

/**
 * Shortcode callbacks
 *    $m1:
 *      0 .... cols
 *      1 .... class
 *      2 .... case
 *      3-6 .. hide_bits
 *      7 .... flag (new in v607)
 *             xxxx xxx0 .. <table>
 *             xxxx xxx1 .. <ul>
 */
function _silotableCback($m)
{
    $ar = explode(',', $m[1]);
    $cols = $ar[0];
    $sty = $ar[1];
    $lcase = $ar[2];
    $flag = (count($ar) > 7)? $ar[7] : 0; // flag for <ul> silo index (v607)
    $xstr = 'Example Text';
    if($lcase == 'u') $xstr = strtoupper($xstr);
    else if( ($lcase == 'l') || ($lcase == 'a') ) $xstr = strtolower($xstr);

    if(! $flag & 0x01)
    {
        // sit <table>
        $tstr = "<table class='$sty'><tr>";

        for($x=0;$x<$cols;$x++) { $tstr .= "<td><a href='#'>$xstr</a></td>"; }
        $tstr .= "</tr><tr>";
        for($x=0;$x<$cols;$x++) { $tstr .= "<td><a href='#'>$xstr</a></td>"; }

        $tstr .= "</tr></table>";
    }
    else
    {
        // sit <ul>
        $tstr = "<ul class='$sty'>";
        for($x=0;$x<$cols*2;$x++)
        {
            $tstr .= "<li><a href='#'>$xstr</a></li>";
        }
        $tstr .= "</ul>";
    }
    return $tstr;
}

function _rlinksCback($m)
{
    list($cols, $sty, $lcase, $quan, $tu, $a) = explode(',', $m[1]);
    $xstr = 'Example Rlink';
    if($lcase == 'u') $xstr = strtoupper($xstr);
    else if( ($lcase == 'l') || ($lcase == 'a') ) $xstr = strtolower($xstr);
    $tu &= 0x01;
    if(! $tu)
    {
        // rlink <table>
        $tstr = "<table class='$sty'><tr>";
        for($x=0;$x<$cols;$x++) { $tstr .= "<td><a href='#'>$xstr</a></td>"; }
        $tstr .= "</tr><tr>";
        for($x=0;$x<$cols;$x++) { $tstr .= "<td><a href='#'>$xstr</a></td>"; }

        $tstr .= "</tr></table>";
    }
    else
    {
        // rlink <ul>
        $tstr = "<ul class='$sty'>";
        for($x=0;$x<$cols*2;$x++)
        {
            $tstr .= "<li><a href='#'>$xstr</a></li>";
        }
        $tstr .= "</ul>";
    }
    return $tstr;
}

/*
function _youtubeCback($m)
{
    $hp   = 0;  // 'px' or '%' (default 'px')
    $wp   = 0;  // 'px' or '%' (default 'px')
    $j = json_decode($m[1], true);
    if( isset($j['hp']) ) $hp = $j['hp'];
    if( isset($j['wp']) ) $wp = $j['wp'];
    $hp = ($hp == 1)? '%' : 'px';
    $wp = ($wp == 1)? '%' : 'px';
    return "<div style=\"height:{$j['h']}{$hp}; width:{$j['w']}{$wp}; background-color:#c4c4c4;border:1px solid black \"><p style=\"text-align:center\">YouTube video placeholder</p></div>";
}
function _yelpCback($m)
{
    $j = json_decode($m[1], true);
    $ht = $j['limit'] * 80;
    return "<div style=\"height:{$ht}px;width:180px;white-space:nowrap; background-color:#c4c4c4;border:1px solid black \"><p style=\"text-align:center\">Yelp placeholder</p></div>";
}
*/

/**
 *
 * Test balance of brace pairs
 *   Return:
 *         0 .. balanced
 *       neg .. missing left brace
 *       pos .. missing right brace
 *
 */
function xece7fXCC()
{
    global $xF8598X1F;
    if(preg_match_all('/({|})/',$xF8598X1F,$m,PREG_PATTERN_ORDER) == 0) return 0;
    $x=0;
    foreach($m[1] as $b)
    {
        if($b == '{') $x++;
        else $x--;
        if($x < 0) return -1;
    }
    return $x;
}

/**
 * surround <style> or <script> with [xospin] (Callback)
 *
 */
function _set_xospinCback($m)
{
    if( strpos($m[0], '{') === false) return $m[0];
    else return "[xospin]$m[0][/xospin]";
}

/**
 * Fix nospin nesting (Callback)
 *
 */
function _fix_nospinCback($m)
{
    global $spin_stat, $xspin_stat;

    // spin_stat .. SPIN_NO or SPIN_NONE
    //
    //        m0 .. <!-- [nospin] -->
    //              <!-- [/nospin] -->
    //              <!-- [dospin] -->
    //              <!-- [/dospin] -->
    //              [nospin]
    //              [/nospin]
    //              [dospin]
    //              [/dospin]
    //              [xospin] 
    //              [/xospin] 
    //
    //        m1 .. [nospin]
    //              [/nospin]
    //              [dospin]
    //              [/dospin]
    //              [xospin]
    //              [/xospin]
    //
    switch(strtolower($m[1]))
    {
        //--------------------------------------------
        case '[xospin]': // begin style or script area
        //--------------------------------------------
            if($spin_stat == SPIN_NO)
            {
                // currently already nospin.. just remove xospin's
                $xspin_stat = ''; // remove [/xospin] when we get there
                return '';        // remove current [xospin]
            }
            else
            {
                // currently spinnable.. surround area with nospins
                $xspin_stat = '[/nospin]'; // will close area with /nospin
                return '[nospin]';
            }
            break;

        //--------------------------------------------
        case '[/xospin]': // end of style or script area
        //--------------------------------------------
            return $xspin_stat;

        //--------------------------------------------
        case '[nospin]': // begin nospin
        case '[/dospin]':
        //--------------------------------------------
            // already nospin area.. remove dupe nospin (or /dospin)
            if($spin_stat == SPIN_NO) return '';

            // currently spinnable area.. set nospin
            $spin_stat = SPIN_NO;
            return '[nospin]';

        //--------------------------------------------
        case '[/nospin]':
        case '[dospin]':
        //--------------------------------------------
            // currently spinable area.. remove dupe /nospin (or dospin)
            if($spin_stat == SPIN_NONE) return '';

            // currently nospin area.. set /nospin
            $spin_stat = SPIN_NONE;
            return '[/nospin]';
    }
}

/**
 *
 * Restore braces that were hidden by NOSPIN
 *
 */
function restoreBraces()
{
    global $xF8598X1F;
    $s = array("\vL","\vP","\vR");
    $r = array('{','|','}');
    $xF8598X1F = str_replace($s,$r,$xF8598X1F);
}

/**
 *
 * hide NOSPIN protected braces
 *
 */
function xDe9159X6()
{
    global $xF8598X1F;
    $xefC176X6 = array('{','|','}');
    $x22a166Xb= array("\vL","\vP","\vR");
    while(preg_match('#^(.*)\[\s*NoSpin\s*\](.*)\[\s*/NoSpin\s*\](.*)#si', $xF8598X1F, $m) == 1)
    {
        $s = str_replace($xefC176X6,$x22a166Xb,$m[2]);
        $xF8598X1F = $m[1].$s.$m[3];
    }
}

/////////////////////////
//
// Spin text via random algorithym (temp.. i'll do permutations later)
//
//   no longer recursive (v296). shouldn't cause nesting errors anymore.
//
function doSpin()
{
    while(aSpin()) {}
    return;
}

function aSpin()
{
    global $xF8598X1F;
    preg_match('#\{(.+?)\}#is',$xF8598X1F,$m);
    if(empty($m)) return false;
    $t = $m[1];
    if(strpos($t,'{')!==false){
        $t = substr($t, strrpos($t,'{') + 1);
    }
    $parts = explode("|", $t);
    $r = str_replace('$','\\$',$parts[array_rand($parts)]);
    $xF8598X1F = preg_replace("+\{".preg_quote($t)."\}+is", $r, $xF8598X1F, 1);
    return true;
}

/**
 *
 * Parse article ==> title, instructions, content
 *
 *   Enter $xx85188XA:
 *      [mpc_wp_title]title text[mpc_wp_title]
 *      ..
 *      [mpc_wp_wphead]as-is head text[mpc_wp_wphead]
 *
 *      [mpc_wp_content]article content[mpc_wp_content]
 *
 *   Return array:
 *      [status] 'ok', 'notitle', 'htmltags', 'nbsp'
 *
 *      [mpc_wp_title] title text
 *      ..
 *      [mpc_wp_content] article content
 *
 */
function parseArticle($xx85188XA, &$ar)
{
    $ar = array(
        'mpc_wp_title' => '',
        'mpc_wp_slug' => '',
        'mpc_wp_parent' => '',
        'mpc_wp_category' => '',
        'mpc_wp_tags' => '',
        'mpc_wp_template' => '',
        'mpc_wp_metadesc' => '',
        'mpc_wp_wphead' => '',
        'mpc_wp_content' => ''
    );
    $ar_keys = array_keys($ar);
    $ar['status'] = 'ok';
    foreach($ar_keys as $k)
    {
        if(preg_match("/\[$k\](.*?)\[$k\]/s", $xx85188XA, $m) !=1) continue;
        $ar[$k] = $m[1];
    }
    // validate the title
    $t = $ar['mpc_wp_title'];
    if($t == '')
    {
        $ar['status'] = 'notitle';
        return;
    }
    if($t != strip_tags($t))
    {
        $ar['status'] = 'htmltags';
        return;
    }
    if(strpos($t, '&nbsp;') !== false)
    {
        $ar['status'] = 'nbsp';
        return;
    }
}

/*******************************************
 * Scan data for non-absolute paths
 *   store them --> tmp/tmp.404.txt for display
 *     type \t line \t string \n
 *
 *   echo status and exit.. do NOT return
 */
function do404()
{
//    $assetFolder = $_GET['assetFolder'];
    $assetFolder = '/'.$_GET['websub'].'/';
    $scanType = $_GET['scanType'];
    $xAC063X21 = array('status'=>'nofile', 'scanType'=>$scanType, 'assetFolder'=>$assetFolder);
    $assetFlen = strlen($assetFolder);

    // force alpha sort order
    $order = array(
      'data-src' => 'adata-src',
        'script' => 'bscript',
          'link' => 'clink',
           'img' => 'dimg',
           'srcset' => 'esrcset',
             'a' => 'fa');

    $slashok = 0;
    if($scanType == 'assf') $slashok = 1;
    if($scanType == 'extf') $slashok = 1;


    $ps = 'script|link|img|a';
    //         0--------------------------------------------------------------------------------
    //         1-------------------------
    //           2--
    //                                     3--------------------------------------------
    $patt = "/(<($ps)[^>]+(?:href|src)=\")(?!http|mailto:|!mpcfolder!|javascript:|tel:|#|\\/#)([^\"]+)/i";

    $ar_outstr = array();
    if(isset($_POST['DATA64']))
    {
        $edstr = base64_decode( str_replace( array('-','_','.'),array('+','/','='), $_POST['DATA64'] ) );
        if(preg_match_all($patt, $edstr, $m, PREG_OFFSET_CAPTURE) > 0)
        {
            //
            // capture 0
            //   m[0][0] = <link href="css/style.css  (full matched string)
            //   m[0][1] = offset to captured text
            //
            // capture 1
            //   m[1][0] = <link href="
            //   m[1][1] = offset to captured text
            //
            // capture 2
            //   m[2][0] = link
            //   m[2][1] = offset to captured text
            //
            // capture 3
            //   m[3][0] = css/style.css
            //   m[3][1] = offset to captured text
            //
            $xAE0118X8 = count($m[3]);
            for($x=0;$x<$xAE0118X8;$x++)
            {
                $tag = $order[strtolower($m[2][$x][0])];
                $xx85188XA = $m[3][$x][0];
                if( (strlen($xx85188XA) > 1) && (substr($xx85188XA, 0, 2) == '//') ) continue;  // dbl slash is abs (url)
                if( ($slashok == 0) && ($xx85188XA[0] == '/') ) continue;
                // skip if assf scan and already 'assetFolder'
                if( ($scanType == 'assf') && (substr($xx85188XA, 0, $assetFlen) == $assetFolder) ) continue;

                $pos = $m[3][$x][1];
                $ar_outstr[] = "$pos\t$tag\t$xx85188XA";
            }
        }   
        // sweep thru for 'data-src' attribute in <div>
        //        0--------------------------
        //                             1-----
        $patt = "/<div[^>]+data-src=\"([^\"]+)/i";
        if(preg_match_all($patt, $edstr, $m, PREG_OFFSET_CAPTURE) > 0)
        {
            //
            // capture 0
            //   m[0][0] = <div ... data-src="...  (full matched string)
            //   m[0][1] = offset to captured text
            //
            // capture 1
            //   m[1][0] = ... (data-src text between quotes. excludes quotes)
            //   m[1][1] = offset to captured text
            //
            //
            $tag = 'adata-src';
            $xlen = count($m[1]);
            for($x=0;$x<$xlen;$x++) // loop thru data-src's 
            {
                $pos = $m[1][$x][1];
                $xx85188XA = $m[1][$x][0];
                $ar_outstr[] = "$pos\t$tag\t$xx85188XA";
            }
        }

        // sweep thru for 'srcset' attribute in <img>
        //        0------------------------
        //                           1-----
        $patt = "/<img[^>]+srcset=\"([^\"]+)/i";
        if(preg_match_all($patt, $edstr, $m, PREG_OFFSET_CAPTURE) > 0)
        {
            //
            // capture 0
            //   m[0][0] = <img ... srcset="...  (full matched string)
            //   m[0][1] = offset to captured text
            //
            // capture 1
            //   m[1][0] = ... (srcset text between quotes. excludes quotes)
            //   m[1][1] = offset to captured text
            //
            //
            $xlen = count($m[1]);
            for($x=0;$x<$xlen;$x++) // loop thru srcsets
            {
                 
                // process images in each srcset
                $patt = "/,\s*([^ ]+)/";
                $xx85188XA = ', '.$m[1][$x][0]; // inserted a ', ' to make the preg simpler
                $off = $m[1][$x][1]; // from $m[1] offset in edstr
                if(preg_match_all($patt, $xx85188XA, $n, PREG_OFFSET_CAPTURE) > 0)
                {
                    //
                    // capture 0
                    //   n[x][0] = ', '.image urls
                    //   n[x][1] = offset to each img str (0,x,x..) will be adding offset in edstr from $m[1]
                    //
                    //
                    //
                    $ylen = count($n[0]);
                    for($y=0;$y<$ylen;$y++) // loop thru images in a srcset
                    {
                        $tag = 'esrcset';
                        //$tag = 'cimg';
                        $xx85188XA = $n[1][$y][0];
                        if( ($xx85188XA[0] == '/') && ($xx85188XA[1] == '/') ) continue;  // dbl slash is abs (url)
                        if( ($slashok == 0) && ($xx85188XA[0] == '/') ) continue;
                        // skip if assf scan and already 'assetFolder'
                        if( ($scanType == 'assf') && (substr($xx85188XA, 0, $assetFlen) == $assetFolder) ) continue;
                        $pos = $off-2 + $n[1][$y][1]; // offset in edstr + offset in srcset string
                        $ar_outstr[] = "$pos\t$tag\t$xx85188XA";
                    }
                }
            }
        }

        $outstr = '';
        if(! empty($ar_outstr))
        {
            // sort ar_outstr by pos. then move tag to beginning of each array item
            sort($ar_outstr, SORT_NUMERIC);
            $ar = array();
            foreach($ar_outstr as $s)
            {
                list($pos, $tag, $xx85188XA) = explode("\t", $s);
                $ar[] = "$tag\t$xx85188XA\t$pos";
            }
            $outstr = implode("\n", $ar);
        }
    }

    if($outstr != "")
    {
        $xAC063X21['status'] = 'yesfile';
        if(! is_dir('tmp')) mkdir('tmp', 0777);
        //
        // tmp.404.txt (each line):
        //     [alpha-order]\t[tag]\t[support-file] [offset]
        //   example:
        //     blink css/style.css 12
        //
        // tmp.edstr.txt:
        //   text string of edit file
        //
        file_put_contents('tmp/tmp.404.txt', $outstr);
        file_put_contents('tmp/tmp.edstr.txt', $edstr);
    }
    echo json_encode($xAC063X21);
    exit();
}

/**
 * Look for possible missed NOSPIN areas
 *
 *   Return:
 *      false .. no warning areas found
 *       true .. found warning areas (save them to ns.txt file
 */
function isNoSpinWarning()
{
    global $xF8598X1F;

    if(preg_match_all('/\{[^\|]*?\}/',$xF8598X1F,$m) > 0)
    {
        file_put_contents('ns.txt', implode("\n", $m[0]));
        return true;
    }
    return false;
}

/**
 * Look for hard-coded canonical, shortlink, og:url
 *
 *   Return:
 *      0 .. none found
 *     +1 .. 'canonical'
 *     +2 .. 'shortlink'
 *     +4 .. 'og:url'
 */
function statCanonical()
{
    global $xF8598X1F;
    
    $xC6E168XE = 0;
    // rel="canonical" or rel="shortlink"
    if(preg_match('/<link.*?rel="canonical".*?>/i',$xF8598X1F,$m) == 1) //<?
    {
        if(preg_match('/href="(.*)"/i', $m[0], $mm) == 1)
        {
            if(preg_match('/[!#]/', $mm[1]) != 1) $xC6E168XE += 1; // found hard-coded 'canonical'
        }
    }
    if(preg_match('/<link.*?rel="shortlink".*?>/i',$xF8598X1F,$m) == 1) //<?
    {
        if(preg_match('/href="(.*)"/i', $m[0], $mm) == 1)
        {
            if(preg_match('/[!#]/', $mm[1]) != 1) $xC6E168XE += 2; // found hard-coded 'shortlink'
        }
    }
    // property="og:url"
    if(preg_match('/<.*?property="og:url".*?>/i', $xF8598X1F, $m) == 1)
    {
        if(preg_match('/content="(.*)"/i',$m[0], $mm) == 1)
        {
            if(preg_match('/[!#]/', $mm[1]) != 1) $xC6E168XE += 4; // found hard-coded 'og:url'
        }
    }
    return $xC6E168XE;
}

$yDce62Xee;
/**
 * Build array of multi-item var labels --> arMultiVar
 *
 *    arMultiVar
 *         [v1]
 *           [label] => 1
 *           [label] => 2
 *           [label] => 3

 *         ...
 *         ...
 *
 *         [v9]
 *           [label] => 1
 *           [label] => 2
 *           [label] => 3
 */
function y1Ba104X0()
{
    global $yDce62Xee, $glb_yB1360XXf;

    $yDce62Xee = array('status'=>0);
    //
    for($x=1;$x<10;$x++)
    {
        $yDce62Xee["v$x"] = array();
        if(! file_exists(__DIR__."/snap/cp_taVar$x")) continue;
        $xx2D3XA2F = fopen(__DIR__ ."/snap/cp_taVar$x", 'r');
        $line = fgets($xx2D3XA2F);
        fclose($xx2D3XA2F);
        //                    1                       2
        if(preg_match('/^\[\[(multi-item:|city-info:)(.+?)\]\]/i', $line, $m) != 1) continue;
        
        // found a multi-item or city-info var
        $ar = explode('^', strtolower(trim($m[2])));
        $xF0F1beXf = 1;
        foreach($ar as $label)
        {
            $yDce62Xee["v$x"][$label] = $xF0F1beXf++;
        }
        $yDce62Xee['status'] = 1;
    }
}

/*****************************************************
 * convert custom var labels --> '#var#'
 *  - converts 1-9 var notation to 00-09 var notation
 *
 * @param String cust var names: label1,label2,..label9
 * @param String (ref) of source to modify
 ****************************************************/
function xC2E8eXa9($x68F95XEB, &$xx85188XA)
{
    global $yDce62Xee;

    $x68F95XEB = str_replace(' ','',$x68F95XEB);
    if($x68F95XEB != ',,,,,,,,')
    {
        // build arrays for preg_replace of cust labels
        $ar = explode(',', $x68F95XEB);
        array_unshift($ar,'url!');
        for($x=0;$x<10;$x++)
        {
            $xBcX87XFC = trim($ar[$x]);
            if($xBcX87XFC != "")
            {
                $x0Ax56XAx[] = '/(#|#\=|#\+|#-|#\~|#[1-9]|#\*)'.$xBcX87XFC.'(#|::\w+#|:[sluthwnpe]#|:[1-9]#)/i';
                $x4335dXeA[] = '$1var'.$x.'${2}';
            }
        }
        // replace custom names with 'var0-9'
        $xx85188XA = preg_replace($x0Ax56XAx,$x4335dXeA,$xx85188XA);
    }

    // any multi-item vars ?
    y1Ba104X0();
    if($yDce62Xee['status'])
    {
        // yes.. change multi-item 'varX::label' --> 'varX:1'-'varX:9'
        //                               1                         2     3
        $xx85188XA = preg_replace_callback("/#(\=|\+|\-|\~|\*|[1-8])?var(\d)::(\w+)#/i",
            function($m)
            {
                global $yDce62Xee;

                $i = '';
                // m1  .. emp ('' or '[=+-~*12345678]')
                // m2  .. var number (1-9)
                // m3  .. slutha: label name (or old style digit)
                if(is_numeric($m[1]))
                {
                    // city-info
                    if( (strlen($m[3]) == 1) && is_numeric($m[3]) ) {
                        $i = $m[3]; // slutha is single digit
                    }else{
                        $i =  $yDce62Xee["v$m[2]"][strtolower($m[3])]; // slutha is named index.. convert to 1-18
                    }
                    if($i > 9) $i -= 9;
                    return '#'.$m[1].'var'.$m[2].':'.$i.'#'; // #<emp>varX:<1-9>
                }
                else
                {
                    //
                    // multi-item
                    //
                    if( (strlen($m[3]) == 1) && is_numeric($m[3]) )  $i = $m[3]; // slutha is single digit
                    else  $i =  $yDce62Xee["v$m[2]"][strtolower($m[3])]; // slutha is named index.. convert to 1-18
                    if($i > 9) {
                        $i -= 9;
                        return '#*var'.$m[2].':'.$i.'#'; // #*varX:<1-9>
                    }else{
                        return '#'.$m[1].'var'.$m[2].':'.$i.'#'; // #<emp>varX:<1-9>
                    }
                }
            },
            $xx85188XA
        );
    }
    //
    // standardize #var# format
    //
    // convert '#+-=var0-9:slutha#' --> '#var+-=00-09:slutha#'
    //                               1                      2   3
    $xx85188XA = preg_replace_callback('/#([\=\+\-\~\*|[1-8])?var(\d)(#|:[sluthwnpe]#|:[1-9]#)/i',
        function($m)
        {
            // m[1] .. (=)current or (-)prev or (+)next or (null)current  (1-8)city-info
            // m[2] .. int 0,1-9 var number
            // m[3] .. var modifier (slutha)
            //
            // return "# var [+-=] 01 :[slutha] #"
            if($m[1] == "") $m[1] = '=';   // "current" now marked by '='
            if($m[3] == '#') $m[3] = ':a#'; // sluth --> slutha
            return '#var'.$m[1].'0'.$m[2].$m[3];
        },
        $xx85188XA
    );
}

/**
 * get comma-separated string of Var Cust labels
 */
function getVarLabels()
{
    $s = pv_snap_get_contents('cp_txVar1');
    for($x=2;$x<10;$x++)
    {
        $s .= ',' . pv_snap_get_contents("cp_txVar$x");
    }
    return $s;
}

/**
 * read snap memory file
 * 
 * @param String filename (i.e. taPath1)
 * 
 * @return String (null file not exist)
 */
function pv_snap_get_contents($fname)
{
    if(!file_exists("snap/$fname")) return "";
    return file_get_contents("snap/$fname");
}

/**
 * (simple var): #var=02:t# -->
 *
 * (multi-item): #var=05:1# --> (index 1-9)
 * (multi-item): #var*05:1# --> (index 1-9)+9
 *
 *  (city-info): #var107:1#
 *                   | | |
 *                   | | --- multi-item index (slutha)
 *                   | |
 *                   | |---- varnum (0-9)
 *                   | 
 *                   |------ * multi-item (bump slutha +9)
 *                   |
 *                   |
 *                   |------ 1,2,3,4 (text,link,img,araw) city-info
 *                   |------ 5,6,7,8 (text,link,img,araw) city-info bump sluth +9
 *
 */
function ycAc83X77(&$xx85188XA)
{
    global $glb_yB1360XXf;

    $xx85188XA = preg_replace_callback('/#var([\+\-\=\~\*\d])0(\d):([asluthwnpe]|[1-9])#/i', 'varCallback', $xx85188XA);
}

/*******************************************************************************
 * replace vars callback routine
 *
 *   m[0] full preg match
 *   m[1]    emp .. 1-4 city-info text,link,imag,araw (index 1-9)
 *               .. 5-8 city-info text,link,imag,araw (index 1-9) +9
 *               .. +-  simple var next/prev
 *               .. *   multi-item bump slutha +9
 *
 *   m[2] varnum .. 1-9
 *               .. '*' bump multi-item index by 9 (not city-item)
 *               .. 1-4 city-item text,link,imag,araw
 *               .. 5-8 city-item text,link,imag,araw (bump index 9)
 *
 *   m[3] slutha .. simple var casing
 *               .. multi-item/city-info lbl index 1-9 or 10-18
 *
 * return value from blueprint, var00-09, or blank
 ******************************************************************************/
function varCallback($m)
{
    global $x3ED3cXF7, $arVarNineN, $Project, $glb_yB1360XXf, $ar_salem;

    $emp = $m[1];
    $varnum = $m[2];
    $slutha = $m[3];

    $v = $x3ED3cXF7[x0dE1fXCF+$varnum];
    switch($slutha)
    {
        // normal slutha
        case 'a':
        case 'e': return $v;
        case 's': return ucfirst(strtolower($v));
        case 'l': return strtolower($v);
        case 'u': return strtoupper($v);
        case 't': return ucwords(strtolower($v));
        case 'w': $v = ucwords(strtolower($v)); return str_replace(' ','+',$v);
        case 'n': return str_replace(' ','_',$v);
        case 'p': return str_replace(' ','+',$v);
        case 'h':
            if($Project->lowurl_yn == 'yes') $v = strtolower($v);
            return str_replace(' ','-',$v);
        // multi-item indexes
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            //
            // multi-item (built-in function) ?
            //
            //               1     
            if(preg_match('/(\w\w)_single\^spintax\^list/', $v, $n) == 1)
            {
                //
                // zipcode multi (8)
                //   use salem,oregon for dummy results
                //
                if($slutha == 1) return '97304';
                if($slutha == 2) return '{97304|97304|97304|97305|97306|97307}';
                return '97304, 97304, 97304, 97305, 97306, 97307';
            }
            if(preg_match('/(\w\w)_lat\^long\^zip/', $v, $n) == 1)
            {
                //
                // lat-long-zip (9)
                //   use salem,oregon for dummy results
                //
                if($slutha == 1) return '44.9329058';
                if($slutha == 2) return '-123.1682908';
                return '97304';
            }
            if(preg_match('/(\w\w)_city-info/', $v, $n) == 1)
            {
                //
                // city-info (10)
                //
                //    n[1] .. ccode 'us'
                //
                //  varnum .. 1-9
                //     emp .. 1-4 slutha as-is
                //     emp .. 5-8 slutha +9
                //  slutha .. 1-9 
                //
                $type = $emp; // 1-8 ('text/atag/img/araw')
                $ar = explode('^', $arVarNineN[$varnum-1]); // 'label^label..'
                $idx = $slutha-1; // default 0-8
                if($emp >4) $idx += 9; // 9-17 index into labels
                $lbl = $ar[$idx]; // lbl indexed 0-17

                // get city info for salem, oregon
                // now hard-coded (no more db call)
                $out = $ar_salem[$lbl];

                // TEXT
                if(($emp == 1) || ($emp == 5)) {
                    return $out;
                }

                // LINK with short anchor
                if( ($emp == 2) || ($emp == 6) )
                {
                    list($a,$lb) = explode('_', $lbl, 2);
                    $anchor = '<<<<< BAD ANCHOR >>>>>';
                    if($lb == 'link') $anchor = 'Google map';
                    if($lb == 'website') $anchor = 'State website';
                    if($lb == 'map') $anchor = 'Google map';
                    if($lb == 'wikipedia') $anchor = 'Wikipedia';
                    if($lb == 'things_to_do') $anchor = 'Things to do';
                    return '<a href="' . $out . '" target="_blank">' . $anchor . '</a>';
                }

                // IMG
                if( ($emp == 3) || ($emp == 7) ) return '<img src="' . $out . '"/>';

                // ARAW
                if( ($emp == 4) || ($emp == 8) ) return '<a href="' . $out . '" target="_blank">' . $out . '</a>';
            }
            // multi-item (user provided)
            $ar = explode('^', $v);
            $i = $slutha; 
            if($emp == '*') $i +=9;
            if($i > count($ar)) return ' '; // out of bounds index
            return $ar[$i-1];
            break;

        default:
            return $m[0]; // just return "#var#" string
            break;
    }
}
/*
function DEBUG($msg) {
   $xcf35XCFE = fopen("DEBUG1","ab");
   fwrite($xcf35XCFE,$msg,strlen($msg));
   fwrite($xcf35XCFE,"\n",1);
   fclose($xcf35XCFE);
}
function ARDEBUG($msg,$xAC063X21,$file = './DEBUG1') {
    $msg .= "\n".print_r($xAC063X21,true);
    $xcf35XCFE = fopen($file,'ab');
    fwrite($xcf35XCFE,$msg,strlen($msg));
    fwrite($xcf35XCFE,"\n",1);
    fclose($xcf35XCFE);
}
*/
?>
