<?php
require_once './MarkdownInterface.php';
require_once './Markdown.php';
use Michelf\Markdown;

list($force_h1, $top_lines, $dir) = explode('^', $_POST['parm']);
$dh = opendir($dir);
while( ($fname = readdir($dh)) !== false )
{
    if( ($fname == '.') || ($fname == '..') ) continue;

    $s = array('?', '[q-mk]');
    $r = array(' ', '?');
    $fdata = file_get_contents("$dir/$fname");
    // remove top lines ?
    if($top_lines > 0)
    {
        $fdata = preg_replace('/^.+\s+/m', '', $fdata, $top_lines); // remove a top lines
    }
    // now at 1st markdown line.. are we to force an <h1>?
    if($force_h1)
    {
        $fdata = preg_replace('/^\W*/', '# ', $fdata, 1);        
    }

    // remove ugly 2,3,4 byte chars
    if(function_exists('mb_convert_encoding'))
    {
        $fdata = str_replace('?', '[q-mk]', $fdata); // protect legit '?'
        $fdata = mb_convert_encoding($fdata, 'ASCII', 'UTF-8'); // filter out unicode chars
        $fdata = str_replace($s, $r, $fdata); // put back legit '?'
    }

    $fdata = Markdown::defaultTransform($fdata);
    file_put_contents("$dir/$fname", $fdata);
}
closedir($dh);
?>
