//////////////////
//
//
//
jQuery(document).ready(function() {
    //
    // init accordion
    //
    $('#accordion').accordion();

    $('#accordion').css('visibility','visible');
});

function pnboxPrev()
{
    var x = $('#f6item').html();
    x--;
    if(x < 1) x = 1;
    $('#f6item').html(x);
}
function pnboxNext()
{
    var x = $('#f6item').html();
    x++;
    $('#f6item').html(x);
}

//////////////////
//
// enter: f#path# as id
//   1st #.. arSelPath index
//   2nd #.. id num
//
function pathSelect(p) {
    var x;
    var id = p.id;
    var idroot = id.substr(0,6);
    var idnum = id.substr(6);

   for(x=1;x<6;x++) {
      $('#'+idroot+x).toggleClass('fsel',false);
   }
   $('#'+id).toggleClass('fsel',true);
   return false;
}

///////////////////
//
// UI for multiple <select>'s
//   enter: f#
//
function multiSelect() {
    var j,x,tf;
    for(x=1;x<6;x++)
    {
        j = $('#f3select'+x);
        tf = (j.prop('selectedIndex') == 0);
        j.toggleClass('fsel', !tf);
    }
}

function trashCan(n)
{
    var j = $('#f3select'+n);
    j.prop('selectedIndex', 0);
    j.toggleClass('fsel', false);
    $('#f3search'+n).val('');
}

function divSelect(p,n) {
    var x;
    var id = p.id;
    var idroot = id.substr(0,id.length-1);
    var idnum = id.charAt(id.length-1);
   for(x=1;x<=n;x++) {
      $('#'+idroot+x).toggleClass('fsel',false);
   }
   $('#'+id).toggleClass('fsel',true);
   return false;
}

var arcmp = ['x','=','!','~'];

function putFormula() {
    var x,c,s,p,pth,pts;
    for(x=1;x<11;x++) {
        if($('#acc'+x).hasClass('selected')) {
            break;
        }
    }
    switch(x) {
        // --------------------------------
        case 1: // [path]
        // --------------------------------
            x = getSelected('f1path',5);
            if(x==0)
            {
                showDiaStatus('Path not selected');
                $('.tdv').toggleClass('pinkback',true);
                return;
            }
            parent.MpcCpanel.pushVarbox('['+$('#f1path'+x).text()+']');
            break;

        // --------------------------------
        case 2: // [path=???]
        // --------------------------------
            x = getSelected('f2path',5);
            if(x==0)
            {
                showDiaStatus('Path not selected');
                $('.tdv').toggleClass('pinkback',true);
                return;
            }
            s = $('#f2search').val();
            if(s=="")
            {
                showDiaStatus('Search string not entered');
                $('input.tds').css('backgroundColor','pink');
                return;
            }
            c = getSelected('f2cmp',3);
            if(c==0)
            {
                showDiaStatus('Compare type not selected');
                $('.tdc').toggleClass('pinkback',true);
                return;
            }
            c = arcmp[c];
            p = $('#f2out').val();
            if(p=="")
            {
                showDiaStatus('Output string not entered');
                $('input.tdo').css('backgroundColor','pink');
                return;
            }
            parent.MpcCpanel.pushVarbox('['+$('#f2path'+x).text()+c+s+']'+p);
            break;

        // --------------------------------
        case 3: // [^path=???&path=????....]
        // --------------------------------
            var obj = {};
            var cnt = 0;
            var v;
            for(x=1;x<6;x++)
            {
                obj['sel'+x] = $('#f3select'+x);
                obj['sch'+x] = $('#f3search'+x);
                if( obj['sel'+x].prop('selectedIndex') > 0)
                {
                    cnt++;
                    v = obj['sch'+x].val();
                    v = v.trim();
                    obj['sch'+x].val(v);
                    if(v == '')
                    {
                        showDiaStatus('Missing Path compare value');
                        $(obj['sch'+x]).css('backgroundColor','pink');
                        return;
                    }
                }
            }
            if(cnt < 2)
            {
                showDiaStatus('Minimum 2 Paths required');
                return;
            }
            // count index values
            var dup = {};
            dup[1] = dup[2] = dup[3] = dup[4] = dup[5] = 0;
            for(x=1;x<6;x++)
            {
                v = obj['sel'+x].prop('selectedIndex');
                if(v > 0) dup[v]++;
            }
            // any dupes ?
            var isdupes = 0;
            for(x=1;x<6;x++)
            {
                if( dup[x] < 2) continue;
                isdupes = x;
                break;
            }
            if(isdupes > 0)
            {
                // found dupes
                for(x=1;x<6;x++)
                {
                    if( obj['sel'+x].prop('selectedIndex') == isdupes)
                    {
                        $(obj['sel'+x]).toggleClass('redborder', true);
                    }
                }
                showDiaStatus('Duplicate Paths selected');
                return;
            }
            var s = '';
            for(x=1;x<6;x++)
            {
                if(obj['sel'+x].val() != '')
                {
                    s += '&'+obj['sel'+x].val();
                    s += '='+obj['sch'+x].val();
                }
            }
            var out = $('#f3out').val();
            parent.MpcCpanel.pushVarbox('['+s+']'+out);
            break;

        // --------------------------------
        case 4: // [==???] output ([==???] for backward compatibility with pre v592)
        // --------------------------------
            c = getSelected('f4cmp',3);
            if(c==0)
            {
                showDiaStatus('Compare type not selected');
                $('.tdc').toggleClass('pinkback',true);
                return;
            }
            c = arcmp[c];
            s = $('#f4search').val();
            if(s=="")
            {
                showDiaStatus('Search string not entered');
                $('input.tds').css('backgroundColor','pink');
                return;
            }
            p = $('#f4out').val();
            if(p=="")
            {
                showDiaStatus('Output string not entered');
                $('input.tdo').css('backgroundColor','pink');
                return;
            }
            parent.MpcCpanel.pushVarbox('['+c+s+']'+p);
            break;

        // --------------------------------
        case 5: // Regex
        // --------------------------------
            s = $('#f5pattern').val();
            if(s=="")
            {
                showDiaStatus('Pattern string not entered');
                $('input.tdx').css('backgroundColor','pink');
                return;
            }
            if(s.charAt(0) != '/')
            {
                showDiaStatus("Pattern must be delimited by '/' slashes");
                $('input.tdx').css('backgroundColor','pink');
                return;
            }
            p = $('#f5out').val();
            if(p=="")
            {
                showDiaStatus('Output string not entered');
                $('input.tdo').css('backgroundColor','pink');
                return;
            }
            parent.MpcCpanel.pushVarbox('['+s+']'+p);
            break;

        // --------------------------------
        case 6: // Aligned Items
        // --------------------------------
            // path string
            pth = getSelected('f6path',5);
            if(pth == 0)
            {
                showDiaStatus('Path not selected');
                $('.tdv').toggleClass('pinkback',true);
                return;
            }
            pts = $('#f6path'+pth).text()

            // selection
            var sel = $('#f6item').html();
            sel = parseInt(sel);    
            sel--; // 0-x

            // separator
            sep = "";
            if($('#cbDash').prop('checked')) sep += '-';
            if($('#cbUnderscore').prop('checked')) sep += '_';
            if($('#cbFolders').prop('checked')) sep += '\\/';
            if($('#cbSpace').prop('checked')) sep += ' ';
            if(sep == "")
            {
                showDiaStatus('Separator not selected');
                $('.tdk').css('backgroundColor','pink');
                return;
            }

            // put in var box
            s = '[:'+pts+':/(?:[^'+sep+']+.){'+sel+'}([^'+sep+']+)/]$1';
            parent.MpcCpanel.pushVarbox(s);
            break;

        // --------------------------------
        case 7: // function(path) Abbreviation Toggle
        // --------------------------------
            pth = getSelected('f7path',5);
            pts = $('#f7path'+pth).text()
            c = $('#f7_sel_country').val(); // 'xx_state_abbreviation'
            parent.MpcCpanel.pushVarbox('[('+pts+')] '+c);
            break;

        // --------------------------------
        case 8: // function(state, city) Zipcodes
        // --------------------------------
            if(! validate_country_state_city('f8')) return;

            var v_state = jQuery('#f8_sel_state').val();
            var v_city = jQuery('#f8_sel_city').val();
            var v_ccode = jQuery('#f8_sel_country').val(); // 'us', 'gb' ..

            e = '';  
            // which btnrad checked?
            var cbox = jQuery('input:radio[name=f8_rad]:checked').val(); // 0-2,5
            if(cbox == 4)
            {
                // multi-item var
                e = '[[multi-item:single^spintax^list]]\n';
                v_ccode += '_single^spintax^list';
            }
            else
            {
                // single item
                v_ccode += '_zipcode';
            }

            // [state-path,city-path,mode] xx_zipcode or xx_single
            parent.MpcCpanel.pushVarbox(e+'[('+v_state+','+v_city+','+cbox+')] '+v_ccode);
            break;

        // --------------------------------
        case 9: // function(country, state, city) Latitude/Longitude 
        // --------------------------------
            if(! validate_country_state_city('f9')) return;

            var v_state = jQuery('#f9_sel_state').val();
            var v_city = jQuery('#f9_sel_city').val();
            var v_ccode = jQuery('#f9_sel_country').val();

            e = '';
            f = jQuery('input:radio[name=f9_rad]:checked').val(); // 0,1,2 --> latitude,longitude,lat^long^zip
            if(f == 0)
            {
                // latitude
                f = 'latitude';
            }
            else if(f == 1)
            {
                // longitude
                f = 'longitude';
            }
            else
            {
                // multi-item

                if(jQuery('#f9_mi_text').html() == 'Lat^Long')
                {
                    e = '[[multi-item:latitude^longitude]]\n';
                    f = 'lat^long';
                }
                else
                {
                    e = '[[multi-item:latitude^longitude^zipcode]]\n';
                    f = 'lat^long^zip';
                }
            }
            // [state-path,city-path] us_latitude or us_longitude or us_latitude,longitude
            parent.MpcCpanel.pushVarbox(e+'[('+v_state+','+v_city+')] '+v_ccode+'_'+f);
            break;

        // --------------------------------
        case 10: // function(country, state, city) City-Info
        // --------------------------------
            if(! validate_country_state_city('f10')) return;

            var v_ccode = jQuery('#f10_sel_country').val();
            var v_state = jQuery('#f10_sel_state').val();
            var v_city = jQuery('#f10_sel_city').val();

            ////////////////////////////////////////////////////////////
            // ok to create city-info formula (multi-item 'type' var)
            //   [[city-info:label1^label2...^label?]]
            //    or
            //   [[city-info:ccode^stateConstant!^cityPath]]
            //
            var cc = v_ccode.toLowerCase();
            var s = v_state.toLowerCase(); // state path or constant!
            var c = v_city.toLowerCase();  // city path

            var e = '[[city-info:'+js_strCityinfo+']]\n';

            parent.MpcCpanel.pushVarbox(e+'[('+s+','+c+')] '+cc+'_city-info');
            break;
    }
}

function validate_country_state_city(fx) {
    var v_ccode = $('#'+fx+'_sel_country').val();
    v_ccode = v_ccode.toLowerCase(); // 'us', 'gb' ...
    var sr = (v_ccode == 'us')? 'State' : 'Region';

    j_state = $('#'+fx+'_sel_state');
    istate = j_state.prop('selectedIndex');
    if(istate == 0)
    {
        showDiaStatus(sr+' Path must be selected');
        j_state.css('backgroundColor','pink');
        return false;
    }
    j_city = $('#'+fx+'_sel_city');
    icity = j_city.prop('selectedIndex');
    if(icity == 0)
    {
        showDiaStatus('City Path must be selected');
        j_city.css('backgroundColor','pink');
        return false;
    }
    if(istate == icity)
    {
        showDiaStatus(sr+' and City are same Path');
        j_state.css('backgroundColor','pink');
        j_city.css('backgroundColor','pink');
        return false;
    }
    return true;
}

function getSelected(rootid,max) {
    var x,retval = 0; // not found

    for(var x=1;x<max+1;x++) {
        if($('#'+rootid+x).hasClass('fsel')) {
            retval = x;
            break;
        }
    }
    return retval;
}

function updateZipDb()
{
    $.ajax({
        url: 'ajax.php',
        async: true,
        type:'POST',
        data: {cmd_ajax:'ajax_updb', mpc_ajax:64 },
        success: function(r) {
            $('#updb').css('visibility','visible');
            $('#updb_a').css('display','none');
        }
    });
}

function showDiaStatus(msg) {
    var el = jQuery('.dia-status');
    el.html(msg);
    //el.css({'color':rgb,'visibility':'visible'});
    el.css({'visibility':'visible'});
}
function hideDiaStatus() {
    $('.tdv').toggleClass('pinkback',false);
    $('.tdc').toggleClass('pinkback',false);
    $('input.tds').css('backgroundColor','white');
    $('input.tdo').css('backgroundColor','white');
    $('input.tdx').css('backgroundColor','white');
    $('.tdk').css('backgroundColor','white');
    $('.sel').css('backgroundColor','white');
    $('#f3search1').css('backgroundColor','white');
    $('#f3search2').css('backgroundColor','white');
    $('#f3search3').css('backgroundColor','white');
    $('#f3search4').css('backgroundColor','white');
    $('#f3search5').css('backgroundColor','white');
    $('#f3select1').toggleClass('redborder', false);
    $('#f3select2').toggleClass('redborder', false);
    $('#f3select3').toggleClass('redborder', false);
    $('#f3select4').toggleClass('redborder', false);
    $('#f3select5').toggleClass('redborder', false);
    var el = jQuery('.dia-status');
    el.css('visibility','hidden');
    el.html('');
}

hideDiaStatusK = function(event) {
    var kc = ('which' in event)? event.which : event.keyCode;
    if(kc != 13) {
        var el = jQuery('.dia-status');
        el.css('visibility','hidden');
        el.html('');
    }
    return false;
}
