<?php
require_once('../iccheck.php');
require_once('../glb.php');
@date_default_timezone_set(date_default_timezone_get());
//////////////////////////////////////////////////////
//
// MPC Editor
//   by Larry Sherman
//
//////////////////////////////////////////////////////

// block phantom gets (from html errors)
if(empty($_POST)) { exit(); }

// read mpc main settings
$arSett = json_decode(file_get_contents('../settings'), true);

//
// posted by Control Panel (base64 encoded since v315)
//
$arPost = json_decode( base64_decode( str_replace( array('-','_','.'),array('+','/','='), $_POST['edData'] ) ), true);
$VER = $arPost['ver'];
$yefXb5X80 = strtolower($glb_yefXb5X80);
$TESTING = $arPost['testing'];
$websub = $arPost['websub'];
$iraw = $arPost['iraw'];
$proto = $arPost['proto'];
$misc = $arPost['misc'];
$ola = $arPost['ola'];
$varNine = $arPost['varNine'];
$fileType = $arPost['fileType'];
$treeSelFname = $arPost['treeSelFname'];
$init_ed_src = $arPost['init_ed_src'];
$ar_jsett = json_decode($arPost['jsett'], true); // some project settings and other things from Form Submit
$dimSave = 0;
//
// from main settings file
//
$tzone = $arSett['tzone'];
$dowp = $arSett['dowp'];
$theTheme = $arSett['theme'];
$bConfOvr = $arSett['conf_ovr'];


// button labels/titles
//
//               saveButton     editmode       saveButtonTitle
//               ----------
// webroot html  Save File      WEB File       Save edited file
// webroot text  Save File      TEXT File      Save edited file
// webroot code  Save File      CODE File      Save edited file
//  
// project html  Save Page      WEB Page       Save edited page
// project text  Save Article   TEXT Article   Save edited article
// project code  Save File      CODE FILE      Save edited file
//
//
$bHtml = ($fileType == 'html');

$bRoot = true; // default dom root file ( non mpc/ file like robots.txt, .htaccess etc)
$ht_savebtn = 'File';
/*$ht_savettl = 'Save edited file'; */
$editmode   = ($bHtml)? 'WEB File' : 'TEXT File';

if(substr($treeSelFname, 0, 3) != '../')
{
    $bRoot = false;
    $ht_savebtn = ($bHtml)? 'Page' : 'Article'; // big blue Save button
    $editmode   = ($bHtml)? 'WEB Page' : 'TEXT Article';
/*    $ht_savettl = ($bHtml)? 'Save edited page' : 'Save edited article';  */
}
$editlink = '';
if($iraw == 1)
{
    $ht_savebtn = 'File';
/*    $ht_savettl = 'Save edited file'; */
    $editmode   = 'CODE File';
}
if(substr($editmode, 0, 4) != 'TEXT')
{
    $editlink .= '<a href="#" onclick="MpcEditor.browseEditFile()" title="Browse Page">Browse</a>';
}
if(substr($editmode, 0, 4) == 'CODE')
{
    $editlink .= ' | <a href="#" onclick="MpcEditor.validateFile()" title="Validate Html">Validate</a>';
    $editlink .= ' | <a href="#" onclick="MpcEditor.mobiletestFile()" title="Test if Mobile Friendly">Mobile</a>';
}

if($editmode == 'TEXT Article')
{
    $editmode = 'WP Source';
    $ht_savebtn = 'WP Source';
}

$exvars = ($bRoot)? 'style="visibility:hidden"' : "";
$exmycmenu = ($bRoot)? ',mycmenu' : "";
//
$xGGcf5Xb0 =    ($TESTING == 1)?       '../../jsfiles/editor.js' : "../js/mpc.editor.$VER.min.js";
$xEEEf0XeX =   ($TESTING == 1)?     '../../cssfiles/editor.css' : "../css/mpc.editor.$VER.min.css";
$ht_sbjs =  ($TESTING == 1)?    '../../jsfiles/shadowbox.js' : "../js/mpc.sbox.$VER.min.js";
$ht_cmjs =  ($TESTING == 1)?    '../../jsfiles/contextMenu.js' : "../js/mpc.cmenu.$VER.min.js";
$ht_sbcss = ($TESTING == 1)?  '../../cssfiles/shadowbox.css' : "../css/mpc.sbox.$VER.min.css";
$ht_cmcss = ($TESTING == 1)?  '../../cssfiles/contextMenu.css' : "../css/mpc.cmenu.$VER.min.css";
$ht_btn =   ($TESTING == 1)?     '../../cssfiles/button.css' : "../css/mpc.button.$VER.min.css";
$ht_cssloc =($TESTING == 1)?     '../../cssfiles' : "../css";
$ht_jq =    ($TESTING == 1)? '../../jsfiles/jquery/jquery-ui-1.13.min.js' : "../js/jquery/jquery-ui-1.13.min.js";

// set theme
require_once '../themesw.php';

// set random nonce (if not already set)
if(! is_file('../non.php')) file_put_contents('../non.php', '<?php $non = \''.mt_rand().'\'; ?>'); // <?
require_once '../non.php'; // sets $non which sets jnon

// set var labels (for var panel)
for($x=1;$x<10;$x++)
{
	$s = snap_file_get_contents('txVar'.$x, 16);
	$ar_varName[$x-1] = ($s == "")? 'Var'.$x : $s;
    // set [path] --> varForms[] for breadcrumbs
	$s = snap_file_get_contents('taVar'.$x, 16);
    $ar_varForm[$x-1] = ' ';
    if($s == "") continue;
    if( preg_match('/^\[\s*(\w+)\s*\]/', $s, $m) != 1) continue;
    $ar_varForm[$x-1] = $m[1];
}

$varNames = json_encode($ar_varName);
$varForms = strtolower(json_encode($ar_varForm));

// get path names (for breadcrumbs)
for($x=1;$x<6;$x++)
{
	$s = snap_file_get_contents('txPath'.$x, 16);
	$ar_pathName[$x-1] = ($s == "")? 'Path'.$x : $s;
    // set pathType[] for breadcrumbs
    //  -1 .. empty path
    //   0 .. just a word
    //   1 .. folder
    //   2 .. silo
	$s = snap_file_get_contents('taPath'.$x, 128);
    $ar_pathType[$x-1] = -1;
    if($s == "") continue;
    $ar = explode('\n', $s, 2);
    if( substr($ar[0], -2) == '//' ) $ar_pathType[$x-1] = 2;
    else if( substr($ar[0], -1) == '/' ) $ar_pathType[$x-1] = 1;
    else $ar_pathType[$x-1] = 0;
}
$pathNames = strtolower(json_encode($ar_pathName));
$pathTypes = json_encode($ar_pathType);

// global vars
$titleBarFn = ""; // for titlebar
$saveFname = "";  // for saveAs popup
$assetFolder = "";  // for 'Asset folder' in Replace dialog
$domainBase = ""; // "http://www.goodlarry.com" domain base
$fileBase = "";   // "http://www.goodlarry.com/[subdir/]" parent-path base of file
$TEXTAREA = "";
$isc = $_SESSION['lt'];

/**
 * Editor Command switch
 */
switch($arPost['FormButton'])
{
	// [Upload From Computer]
	case 'fileUpload':
/*
		$domainBase = "";  // none
		$fileBase   = "";  // none
		$titleBarFn = 'New Uploaded File';
		//$URL = substr_replace($glb_y0F0baXb2, '_aux/upfile', -4);
		$TEXTAREA = @file_get_contents("../uploads/$misc");
		if($TEXTAREA === false) $TEXTAREA = "Unable to read from $misc. Please check file permissions.<br />";
*/
	break;

	//----------------------------------------
	case 'editPage': // [Mpc Page From Tree]
	//----------------------------------------
		$saveFname = $treeSelFname;
		$titleBarFn = $treeSelFname;

        if($bRoot) $titleBarFn = substr( $titleBarFn, strlen($glb_dotdot) );
        else if($misc == 'backup') backupFile($treeSelFname); // backup if requested

		// set vars for popups etc
		$domainBase = "$proto://$glb_x9Ba196Xc"; // "http://www.domain.com"
		$fileBase   = "$proto://$glb_y4axb9Xae";   // "http://www.domain.com/subdir/aa/bb/cc/
		// if loaded a backup.. adj titleBarFn and saveFname

		if(preg_match('/^\.Backup-Files\/(.+?)(-\d{8}-\d{2}h\d{2}m\d{2})$/', $treeSelFname, $m) == 1)
		{
			$pos = strrpos($treeSelFname, '/');
			$xx85188XA = substr($treeSelFname,14,$pos-14);
			$titleBarFn = "$xx85188XA"."$m[2]";
			$saveFname = $xx85188XA;
		}
		// fill-in edit box
        if( substr($treeSelFname, -1) == '/')
        {
            $TEXTAREA = 'Cannot edit a folder.<br />';
            $dimSave = 1;
/*            $ht_savettl = 'Cannot Save a Folder'; */
        }
        else
        {
            $TEXTAREA = @file_get_contents("../../$treeSelFname");

            // is this a [front] file?
		    if(  ($TEXTAREA !== false)  && (substr($treeSelFname, 0 ,3) != '../') )
            {
                $ef = file_get_contents("$glb_yB1360XXf/snap/cp_taSource");
                $ep = "\[front\] ?$treeSelFname ?\>";
                if(preg_match("@$ep@", $ef, $m) == 1)
                {
                    file_put_contents("$glb_yB1360XXf/isfront.php", 1);
                }
                else
                {
                    file_put_contents("$glb_yB1360XXf/isfront.php", 0);
                }
            }
        }

		if($TEXTAREA === false)
        {
            if($bRoot) $TEXTAREA = "<b>$titleBarFn</b> file does not exist.<br />";
            else $TEXTAREA = "Unable to read <b>$treeSelFname</b>. Please check file permissions.<br />";
        }

        // set assetFolder "/max/subfolder/"
        $assetFolder = $glb_xF3X195XC;
        $pos = strpos($saveFname, '/');
        {
            if($pos !== false) $assetFolder .= '/' . substr($saveFname, 0, $pos);
        }
        $assetFolder .= '/';
	break;

	//----------------------------------------
	case 'newBlank': // from [Add to project/Edit new...] contextmenu
	//----------------------------------------
		$saveFname = $treeSelFname;
        $titleBarFn = $treeSelFname;

		// set vars for popups etc
		$domainBase = "$proto://$glb_x9Ba196Xc"; // "http://www.domain.com"
		$fileBase   = "$proto://$glb_y4axb9Xae";   // "http://www.domain.com/subdir/aa/bb/cc/

		// fill-in edit box (if not Code edit)
        if($iraw != 1)
        {
            // html or text edit
            if($fileType == 'text') $TEXTAREA = "New Blank WP Source";
            else $TEXTAREA = "<!DOCTYPE html>\n<html>\n<head><title></title><meta charset=\"utf-8\" />\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\" />\n</head><body>New Blank WEB Page</body></html>";
        }

        // set assetFolder "/max/subfolder/"
        $assetFolder = $glb_xF3X195XC;
        $pos = strpos($saveFname, '/');
        {
            if($pos !== false) $assetFolder .= '/' . substr($saveFname, 0, $pos);
        }
        $assetFolder .= '/';
	break;
}

// smart constants
$af = trim($assetFolder, '/');
$domurl = $proto.'://'.$glb_x9Ba196Xc;
$pfurl = $domurl.'/'.$af;
$wrpath = $glb_y5d1b6XC2;
$pfpath = $wrpath.'/'.$af;

// add smart contants to varNine object (for Preview)
$ar = json_decode($varNine, true);
    $ar['domurl'] = $domurl;
    $ar['pfurl'] = $pfurl;
    $ar['pfpath'] = $pfpath;
    $ar['wrpath'] = $wrpath;
$varNine = json_encode($ar);

// set names for Var buttons
$xCityinfo = 0; // default no city-info vars
$ar_vbtnNames = array();
for($x=1;$x<10;$x++)
{
    if( $ar['n9'][$x-1] == ' ' )
    {
        // no labels.. not multi-item 'label1^label2^label3'
        $ar_vbtnNames[] = $ar_varName[$x-1]; // 'state' or 'VarX' etc
    }
    else
    {
        //multi-item append '...'
        $ar_vbtnNames[] = $ar_varName[$x-1].'...';
        if( substr($ar['v9'][$x-1], 2) == '_city-info') $xCityinfo |= 0x01 << ($x-1); // 0001 - 100000000
    }
}
// set path for  code file browse
//$realPath = realpath("$glb_yAd461XbC/$saveFname");
$realPath = "$glb_xF3X195XC/$saveFname";

// remove existing symlinks (if any)
try{
    if( is_link('!project-url!') ) @unlink('!project-url!');
    if( is_link('!project-path!') ) @unlink('!project-path!');
    if( is_link('!webroot-path!') ) @unlink('!webroot-path!');
}
catch(Exception $e) { }

// make symlinks for project-url and -folder smart constants (so images etc will show in visual mode)
if(! $bRoot) // not if webroot
{
    try{
        @symlink($pfurl, '!project-url!');
        @symlink($pfpath, '!project-path!');
        @symlink($wrpath, '!webroot-path!');
    }
    catch(Exception $e) { }
}

if( ($fileType == 'text') && ($iraw != 1) )
{
	$eol = array("\r\n","\r","\n");
	$TEXTAREA = str_replace($eol,'<br />',$TEXTAREA);
}
if($iraw == 1)
{
    // Code file
    $TEXTAREA = htmlspecialchars($TEXTAREA, ENT_SUBSTITUTE | ENT_QUOTES | ENT_HTML401); // replace bad chars with #FDDD - larry 1/9/2015
}
else
{
    // not Code file
//  $TEXTAREA = htmlspecialchars($TEXTAREA); // convert brackets to &lt; etc.
//  $TEXTAREA = htmlspecialchars($TEXTAREA, ENT_NOQUOTES | ENT_HTML401); // save double quotes - larry 4/27/2013
    $TEXTAREA = htmlspecialchars($TEXTAREA, ENT_SUBSTITUTE | ENT_NOQUOTES | ENT_HTML401); // replace bad chars with #FDDD - larry 1/9/2015
}

/**
 * Backup the incoming file
 */
function backupFile($fn)
{
    global $tzone;
	if(is_file("../../$fn"))
	{
		$xbeF42Xd7 = pathinfo($fn);
		$dirname = $xbeF42Xd7['dirname'] . '/';
		if($dirname == './') $dirname = ""; // 'path1' or 'path1/path2' or ''
		$basename = $xbeF42Xd7['basename'];
		if(! is_dir("../../.Backup-Files/$dirname$basename")) mkdir("../../.Backup-Files/$dirname$basename", 0777, true);

        // timestamp
        $stamp = getTimestampE($tzone);

		// write the backup file
		copy("../../$fn", "../../.Backup-Files/$fn/$basename$stamp");
	}
}

/**
 * get timestamp YYYYMMDD-HHhMMmSS
 *   @param {string}  +-1 thru +-2 (or 'gmt')
 */
function getTimestampE($offset)
{
    $x2CGaeX00 = new DateTime( 'now', new DateTimeZone('GMT') );
    if( strtolower($offset) != 'gmt')
    {
        $t = (int)substr($offset, 1, 1);
        if( substr($offset, 0, 1) == '+')
        {
            // add
            $x2CGaeX00->add( new DateInterval('PT'.$t.'H') );
        }
        else
        {
            // sub
            $x2CGaeX00->sub( new DateInterval('PT'.$t.'H') );
        }
    }
    return $x2CGaeX00->format('\-Ymd-H\hi\ms'); // include seconds (for backup file tstamp)
}

//////////////////
//
// strip "http://"
//
function trimHttp($xx85188XA, &$htt)
{
	$u = trim($xx85188XA);
    $xdcX11eXa = strtolower($u);
    if( substr($xdcX11eXa, 0, 7) == 'http://' )
    {
        $htt = 'http://';
		return substr($u,7);
    }
    else if( substr($xdcX11eXa, 0, 8) == 'https://' )
    {
        $htt = 'https://';
		return substr($u,8);
    }
    else
    {
        $htt = 'http://';
		return $u;
    }
}


function DEBUG($msg) {
	file_put_contents('DEBUG',$msg."\n",FILE_APPEND);
}
function ARDEBUG($msg,$xAC063X21,$file = './DEBUG') {
	$msg .= "\n".print_r($xAC063X21,true);
	file_put_contents($file, $msg."\n",FILE_APPEND);
	$xcf35XCFE = fopen($file,'ab');
}


/**
 * read snap file (return null if no file)
 *
 */
function snap_file_get_contents($fn, $xAE0118X8 = -1)
{
	if(!file_exists("../snap/cp_$fn")) return "";
    if($xAE0118X8 == -1) return file_get_contents("../snap/cp_$fn");
    else return file_get_contents("../snap/cp_$fn", false, NULL, 0, $xAE0118X8);
}

$paste_domurl = "Paste http://$yefXb5X80 at cursor location";
$paste_mpcurl = "Paste http://$yefXb5X80$glb_xF3X195XC/ at cursor location";
$const_folder = "Insert !mpcfolder! at cursor location.\r\nBuilds into: //$yefXb5X80$glb_xF3X195XC";
$const_domain = "Insert !mpcdomain! at cursor location.\r\nBuilds into: //$yefXb5X80";

// make nonce folder in aux dir
$nd = "$glb_yAd461XbC/$glb_yGbb5fXB0/non";
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>MPC - <?php echo $titleBarFn ?></title>
<link  href="<?php echo $ht_btn ?>" rel="stylesheet" type="text/css" />
<script src="ckeditor44/ckeditor.js?v=600"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"></script>
<script src="<?php echo $ht_jq ?>"></script>
<script src="<?php echo $xGGcf5Xb0 ?>"></script>
<script src="<?php echo $ht_cmjs ?>"></script>
<script src="<?php echo $ht_sbjs ?>"></script>
<link  href="<?php echo $xEEEf0XeX ?>" rel="stylesheet" type="text/css" />
<link  href="<?php echo $ht_sbcss ?>" rel="stylesheet" type="text/css" />
<link  href="<?php echo $ht_cmcss ?>" rel="stylesheet" type="text/css" />
<link rel="icon" type="image/png" href="../images/favicon16.png" sizes="16x16">
<link rel="icon" type="image/png" href="../images/favicon32.png" sizes="32x32">
<!--
<script src="https://kit.fontawesome.com/291c3406c8.js" crossorigin="anonymous"></script>
-->
<script type="text/javascript">
	Shadowbox.init({skipSetup:true, animateFade:0, modal:true,enableKeys:false});
	MpcEditor.php = {
		bRaw : <?php echo ($iraw == '1')? 'true':'false' ?>,
		VER : '<?php echo $VER ?>',
		TESTING : '<?php echo $TESTING ?>',
		websub : '<?php echo $websub ?>',
		silkdir : '<?php echo $ht_cssloc.'/silk/' ?>',
        dimSave : '<?php echo $dimSave ?>',
		jRoot : <?php echo ($bRoot)? '1':'0' ?>,
		dotdot : '<?php echo $glb_dotdot ?>',
		dowp : '<?php echo $dowp ?>',
		are : '<?php echo $arPost['are'] ?>',
		jHtml : <?php echo ($bHtml)? 'true':'false' ?>,
		jAbs : '<?php echo $fileBase ?>',
		jnon : '<?php echo $non ?>',
		domurl : '<?php echo $domurl ?>',
		pfurl : '<?php echo $pfurl ?>',
		pfpath : '<?php echo $pfpath ?>',
		wrpath : '<?php echo $wrpath ?>',
		jDomain : '<?php echo $domainBase ?>',
		jDomainP : '<?php echo $yefXb5X80 ?>',
		thePath : '<?php echo $glb_y4axb9Xae ?>',
		mpcpath : '<?php echo $glb_yAd461XbC ?>',
		eye : '<?php echo $arPost['eye'] ?>',
		theAuxDir : '<?php echo $glb_yGbb5fXB0 ?>',
		saveFname : '<?php echo $saveFname ?>',
		realPath : '<?php echo $realPath ?>',
		assetFolder : '<?php echo $assetFolder ?>',
		formbtn : '<?php echo $arPost['FormButton'] ?>',
		bxd : <?php echo $arPost['sxd'] ?>,
		isc : <?php echo $isc ?>,
		init_ed_src : '<?php echo $init_ed_src ?>',
		theDirname : '<?php echo $glb_xF3X195XC ?>',
		fileType : '<?php echo $fileType ?>',
		theFname : '<?php echo $glb_y37Bb7X7F ?>',
		theFnameUrl : '<?php echo $glb_y0F0baXb2 ?>',
		theFnameFld : '<?php echo $glb_y4xdbbXAE ?>',
		thm_sbload : '<?php echo $thm_sbload ?>',
		thm_sbbody : '<?php echo $thm_sbbody ?>',
		thm_text : '<?php echo $thm_text ?>',
		thm_btnFull : '<?php echo $thm_btnFull ?>',
		thm_btnUnSel : '<?php echo $thm_btnUnSel ?>',
		thm_inpColor : '<?php echo $thm_inpColor ?>',
		thm_inpBgnd : '<?php echo $thm_inpBgnd ?>',
		thm_inpBord : '<?php echo $thm_inpBord ?>',
		thm_sberrColor : '<?php echo $thm_sberrColor ?>',
		thm_sberrBgnd : '<?php echo $thm_sberrBgnd ?>',
		thm_pinstripe : '<?php echo $thm_pinstripe ?>',
		thm_dbtnSel : '<?php echo $thm_dbtnSel ?>',
		ola : '<?php echo $arPost['ola'] ?>',
		cin : '<?php echo $arPost['cin'] ?>',
		varNine : "",
		varNineObj : <?php echo $varNine ?>,
        vbtnNames : '<?php echo implode(',', $ar_vbtnNames) ?>',
		varNames : <?php echo $varNames ?>,
        xCityinfo : <?php echo $xCityinfo ?>,
		pathNames : <?php echo $pathNames ?>,
		pathTypes : <?php echo $pathTypes ?>,
		varForms : <?php echo $varForms ?>,
		lowurl_yn : "<?php echo $ar_jsett['lowurl_yn'] ?>",
		bcEndType : "<?php echo $ar_jsett['bcEndType'] ?>",
		bcEndValue : "<?php echo $ar_jsett['bcEndValue'] ?>",
		cm_font_size : '<?php echo $arSett['cm_font_size'] ?>',
		cm_font_weight : '<?php echo $arSett['cm_font_weight'] ?>',
		cm_line_height : '<?php echo $arSett['cm_line_height'] ?>',
		wpi_use_font : '<?php echo $arSett['wpi_use_font'] ?>',
		bAnimate : <?php echo $arSett['anim'] ?>
	};

function animOutE()
{
    anim_blockE = 0;
}
function animInE()
{
    if( (anim_blockE == 0) && (anim_block1E == 0) )
    {
        anim_blockE = 1;
        anim_block1E = 1;
        jQuery('#anim_logo').attr('src', '<?php echo "../images/MPCblue_animE.gif"?>');
        setTimeout(function() { anim_block1E = 0; }, 800);
    }
}
</script>
<style type="text/css">
.pinstripeV {
	background-color:#f8f8f8;
	border-color:#f8f8f8;
}

.qm {
    color:#3a3a3a;
}

.pinstripe {
	border-color:<?php echo $thm_pinstripe ?>;
	background-color:<?php echo $thm_sbload ?>;
}
.pinstripe1 {
	border-color:<?php echo $thm_pinstripe ?>;
}
input#txFind,input#txRepl,#taIns,input#txDomain {
	background-color:<?php echo $thm_inpBgnd ?>;
	color:<?php echo $thm_inpColor ?>;
	border-color:<?php echo $thm_inpBord ?>;
}
.selok:hover {background-color:<?php echo $thm_dbtnHov ?>}
.cvarsel, .cvarsel:hover,.fsel, .fsel:hover {background-color:<?php echo $thm_dbtnSel ?>}
.ysel, .ysel:hover {background-color:gold}
.noselect {
   -moz-user-select: -moz-none;
   -khtml-user-select: none;
   -webkit-user-select: none;
	cursor:default;
}
#edittype a {color:blue;text-decoration:none}
#edittype a:hover {text-decoration:underline}

.roundtl {
    -moz-border-radius-topleft:10px;
    border-top-left-radius:10px;
    webkit-border-top-left-radius:10px;
}
.roundtr {
    -moz-border-radius-topright:10px;
    border-top-right-radius:10px;
    webkit-border-top-right-radius:10px;
}
.sexybutton.sexysimple, #sb-title-inner {
    text-shadow:1px 1px black;
}

.cp_table {
    width:100%;
    white-space:nowrap;
}

.cp_table th {
    padding:5px 10px 5px 10px;
    color:white;
    font-weight:bold;
    background-color:#3a3a3a;
}
.cp_table td.mi19 {
    padding:1px 10px;
    font-weight:normal;
}
.cp_table td.mi19:hover {
    background-color:#b5d5ff;
}
.cp_close {
    color:gold;
    padding: 0 10px 0 0;
    font-weight:bold;
    background-color:#3a3a3a;
}
.cp_close:hover {
    text-decoration:underline;
}
.cp_div {
    position:fixed;
    left:0;
    top:239;
    padding-bottom:4px;
    width:310px;
    background-color:#f0f0f0;
    font-size:14px;
    box-shadow:4px 4px 5px #808080;
    border:1px solid #3a3a3a;
    cursor:default;
    display:none;
    z-index:999999;
}
.cp_divDI {
    position:fixed;
    left:0;
    top:239;
    padding-bottom:4px;
    min-width:500px;
    background-color:#f0f0f0;
    font-size:14px;
    box-shadow:4px 4px 5px #808080;
    border:1px solid #3a3a3a;
    cursor:default;
    display:none;
    z-index:999999;
}
</style>
</head>
<body style="background:<?php echo $thm_sbbody ?>;color:<?php echo $thm_text ?>">

<div class="cp_div noselect roundtop" id="popupMenu1"></div>
<div class="cp_div noselect roundtop" id="popupMenu2"></div>
<div class="cp_div noselect roundtop" id="popupMenu3"></div>
<div class="cp_div noselect roundtop" id="popupMenu4"></div>
<div class="cp_div noselect roundtop" id="popupMenu5"></div>
<div class="cp_div noselect roundtop" id="popupMenu6"></div>
<div class="cp_div noselect roundtop" id="popupMenu7"></div>
<div class="cp_div noselect roundtop" id="popupMenu8"></div>
<div class="cp_div noselect roundtop" id="popupMenu9"></div>

<div class="cp_div noselect roundtop" id="popupMenuC1"></div>
<div class="cp_div noselect roundtop" id="popupMenuC2"></div>
<div class="cp_div noselect roundtop" id="popupMenuC3"></div>
<div class="cp_div noselect roundtop" id="popupMenuC4"></div>
<div class="cp_div noselect roundtop" id="popupMenuC5"></div>
<div class="cp_div noselect roundtop" id="popupMenuC6"></div>
<div class="cp_div noselect roundtop" id="popupMenuC7"></div>
<div class="cp_div noselect roundtop" id="popupMenuC8"></div>
<div class="cp_div noselect roundtop" id="popupMenuC9"></div>

<div class="cp_div noselect roundtop" id="popupMenuS1"></div>
<div class="cp_div noselect roundtop" id="popupMenuS2"></div>
<div class="cp_div noselect roundtop" id="popupMenuS3"></div>
<div class="cp_div noselect roundtop" id="popupMenuS4"></div>
<div class="cp_div noselect roundtop" id="popupMenuS5"></div>
<div class="cp_div noselect roundtop" id="popupMenuS6"></div>
<div class="cp_div noselect roundtop" id="popupMenuS7"></div>
<div class="cp_div noselect roundtop" id="popupMenuS8"></div>
<div class="cp_div noselect roundtop" id="popupMenuS9"></div>

<div class="cp_div cp_divDI noselect roundtop" id="popupMenuDI"></div>

<ul id="menu_W" style="display:none">
    <li title="" onclick="MpcEditor.bnReplaceClick()"><img src="<?php echo $ht_cssloc ?>/silk/repl.png" class="iw-mIcon" />Find/Replace...</li>
</ul>

<ul id="menu_E" style="display:none">
<?php
if($dowp == 1) {
echo '<li title="" id="menudim_wp" onclick="MpcEditor.diaWordpress();MpcEditor.cmfocus()"><img src="'.$ht_cssloc.'/silk/wordpress.png" class="iw-mIcon" />Wordpress instructions...</li>';} ?>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/stop_red.png" class="iw-mIcon" /><b>No</b>spin markers
        <ul>
            <li title="" class="wpdim" onclick="MpcEditor.pageNospin(true);MpcEditor.cmfocus()"> <img src="<?php echo $ht_cssloc ?>/silk/stop_red.png" class="iw-mIcon" />Entire page</li>
            <li title="" onclick="MpcEditor.wrapNospin();MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_red.png" class="iw-mIcon" />Selected area</li>
            <li title="" onclick="MpcEditor.submitSnip('beg_nospin');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_red.png" class="iw-mIcon" />Begin nospin</li>
            <li title="" onclick="MpcEditor.submitSnip('end_nospin');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_red.png" class="iw-mIcon" />End nospin</li>
            <li title="" onclick="MpcEditor.removeNospin();MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/delete.png" class="iw-mIcon" />Remove all</li>
        </ul>
    </li>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/stop_green.png" class="iw-mIcon" /><b>Do</b>spin markers
        <ul>
            <li title="" onclick="MpcEditor.wrapDospin();MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_green.png" class="iw-mIcon" />Selected area</li>
            <li title="" onclick="MpcEditor.submitSnip('beg_dospin');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_green.png" class="iw-mIcon" />Begin dospin</li>
            <li title="" onclick="MpcEditor.submitSnip('end_dospin');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/stop_green.png" class="iw-mIcon" />End dospin</li>
            <li title="" onclick="MpcEditor.removeDospin();MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/delete.png" class="iw-mIcon" />Remove all</li>
        </ul>
    </li>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/link.png" class="iw-mIcon" />Special links
        <ul>
            <li title="" onclick="MpcEditor.submitSnip('prev_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/link.png" class="iw-mIcon" />Previous page</li>
            <li title="" onclick="MpcEditor.submitSnip('next_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/link.png" class="iw-mIcon" />Next page</li>
            <li title="" onclick="MpcEditor.submitSnip('curr_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/link.png" class="iw-mIcon" />Current page</li>
        </ul>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />Smart constants
        <ul>
            <li title="[CURRENT] <?php echo $domurl.'/PageUrl' ?>" onclick="MpcEditor.submitSnip('dom_page_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />Page url</li>
            <li title="[CURRENT] <?php echo $domurl ?>" onclick="MpcEditor.submitSnip('dom_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />Domain url</li>
<!--
            <li title="[CURRENT] <?php echo $pfurl ?>" onclick="MpcEditor.submitSnip('pf_url');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />ProjectFolder url</li>
            <li title="[CURRENT] <?php echo $pfpath ?>" onclick="MpcEditor.submitSnip('pf_path');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />ProjectFolder path</li>
-->
            <li title="[CURRENT] <?php echo $wrpath ?>" onclick="MpcEditor.submitSnip('wr_path');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/lightbulb.png" class="iw-mIcon" />WebrootFolder path</li>
        </ul>
    </li>
<!--
    <li title="">
    <img src="<?php echo $ht_cssloc ?>/silk/paste_plain.png" class="iw-mIcon" />Paste urls
        <ul>
            <li title="<?php echo $paste_domurl ?>" onclick="MpcEditor.submitSnip('dom_url');MpcEditor.cmfocus()"</li>
            <img src="<?php echo $ht_cssloc ?>/silk/paste_plain.png" class="iw-mIcon" />Domain url</li>

            <li title="<?php echo $paste_mpcurl ?>" onclick="MpcEditor.submitSnip('abs_path');MpcEditor.cmfocus()"</li>
            <img src="<?php echo $ht_cssloc ?>/silk/paste_plain.png" class="iw-mIcon" />Mpc folder</li>
        </ul>
-->
    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Widgets
        <ul>
            <li title="" onclick="MpcEditor.goWidget('Map');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Google Maps...</li>

            <li title=""  onclick="MpcEditor.goWidget('Rlinks');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Related Links...</li>
            <li title=""  onclick="MpcEditor.goWidget('Sit');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Silo Index Links...</li>
            <li title="" onclick="MpcEditor.goWidget('AddBread');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Add Breadcrumb...</li>
            <li title="" onclick="MpcEditor.goWidget('RepBread');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget.png" class="iw-mIcon" />Replace Breadcrumb...</li>
            <li title="" onclick="MpcEditor.goWidget('DelBread');return false;"><img src="<?php echo $ht_cssloc ?>/silk/widget_red.png" class="iw-mIcon" />Delete Breadcrumb...</li>
        </ul>
    </li>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/comment.png" class="iw-mIcon" />Html comments
        <ul>
            <li title="" onclick="MpcEditor.htmlComment('add');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/comment_add.png" class="iw-mIcon" />Comment selected</li>
            <li title="" onclick="MpcEditor.htmlComment('rm');MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/comment_delete.png" class="iw-mIcon" />UNcomment selected</li>
        </ul>
    </li>

    <li title="" onclick="MpcEditor.diaMeta()"><img src="<?php echo $ht_cssloc ?>/silk/tags_black.png" class="iw-mIcon" />Meta tags...</li>

    <li title=""><img src="<?php echo $ht_cssloc ?>/silk/tag.png" class="iw-mIcon" />Canonical tags
        <ul>
            <li title="" onclick="MpcEditor.addCanon(0);MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/tag.png" class="iw-mIcon" />Add canonical</li>
            <li title="" onclick="MpcEditor.addCanon(1);MpcEditor.cmfocus()"><img src="<?php echo $ht_cssloc ?>/silk/tag.png" class="iw-mIcon" />Add canonical (domain only)</li>
            <li title="" onclick="MpcEditor.removeCanon();return false;"><img src="<?php echo $ht_cssloc ?>/silk/tags_red.png" class="iw-mIcon" />Remove all</li>
        </ul>
    </li>

    <li title="" onclick="MpcEditor.diaBacklink()"><img src="<?php echo $ht_cssloc ?>/silk/backlink.png" class="iw-mIcon" />Link builder...</li>
    <li title="" onclick="MpcEditor.bnReplaceClick()"><img src="<?php echo $ht_cssloc ?>/silk/repl.png" class="iw-mIcon" />Find/Replace...</li>
    <li title="Report pathing that may cause 404 errors" class="wpdim" onclick="MpcEditor.bn404Click()"><img src="<?php echo $ht_cssloc ?>/silk/error.png" class="iw-mIcon" />Scan 404...</li>
</ul>

<div id="wrapper" class="noselect">
<form id="epage" name="epage">
  <div class="banner_ck" style="position:relative">
    <div style="width:100%;height:64px">
		<table cellpading="0" cellspacing="0" border="0"><tr>
            <td style="text-align:left;vertical-align:top">
                    <div style="padding:7px 0 0 19px"  onmouseenter="animInE()" onmouseleave="animOutE()">
                        <img id="anim_logo" src="<?php echo '../images/MPCblue_animE.gif'?>" height="51" width="199" />
                    </div>
            </td>
            <td width="95%"><div id="pwait" style="text-align:center;padding-top:2px;margin:0 10px 0 5px">Processing.. please wait</div></td>
			<td valign="top">
				<div style="padding-top:15px;padding-right:21px">

					<button class="sexybutton sexysimple sexyblue sexylarge" id="bnSaveAs"
            		onclick="MpcEditor.xMD();MpcEditor.syncSource();MpcEditor.saveEdit('<?php echo $bConfOvr ?>');return false;"

                    onContextmenu="MpcEditor.xMD();MpcEditor.syncSource();MpcEditor.saveEdit_rclick();return false;"

				 		disabled="disabled"><span class="save">Save <?php echo $ht_savebtn ?></span></button>

					&nbsp;

					<button class="sexybutton sexysimple sexyblack sexylarge" id="bnClose" title="Return to Control Panel"
	 					onclick="MpcEditor.xMD();MpcEditor.confirmClose(); return false;" disabled="disabled">
					<span class="cancel">Close Editor</span></button>

				</div>
			</td>
		</tr></table>
    </div>
  </div>

  <div id="page" spellcheck="false">
	<div id="btnrow">
		<table>
		  <tr style="white-space:nowrap">

			 <td>
				<!-- Source/Visual -->
				<div class="btngroup pinstripe">
					<button class="sexybutton" onClick="MpcEditor.clickSource(); return false;" id="bnSource" disabled="disabled" title="Set SOURCE mode display">
					<span><span><span class="page_white_text">Source</span></span></span>
					</button><button class="sexybutton marginleft6" onClick="MpcEditor.clickVisual(); return false;" id="bnVisual" disabled="disabled" title="Set WYSIWYG mode display">
					<span><span><span class="television">Visual</span></span></span></button>
				</div>
			</td>
			<td><div class="spacer"></div></td>
			 <td>
				<!-- Var/Edit -->
				<div class="btngroup pinstripe">
					<button class="sexybutton" onClick="MpcEditor.toggleVarsEdits();return false;" id="bnVars" disabled="disabled" title="Display VAR controls">
					<span><span><span class="myvars">Var</span></span></span>
					</button><button class="sexybutton marginleft6" onClick="MpcEditor.toggleVarsEdits();return false;" id="bnEdits" disabled="disabled" title="Display EDITOR controls">
					<span><span><span class="pencil_bw">Edit</span></span></span></button>
				</div>
			</td>
			<td><div class="spacer"></div></td>
			<td>
				<!-- Preview -->
				<div class="xbtngroup">
<!--
					//<button class="sexybutton" onClick="MpcEditor.syncSource();MpcEditor.doButton('mypreview');return false;" id="bnMyPreview" disabled="disabled"
-->
					<button class="sexybutton" onClick="MpcEditor.goPreview();return false;" id="bnMyPreview" disabled="disabled"
					 title="<? echo ($bHtml)? 'Preview page. Test Spintax and check for Canonical tags.':'Preview Article. Show Title and Instruction lines.' ?>">
					<span><span><span class="page_white_magnify">Preview</span></span></span></button>
				</div>
			</td>
			<td><div class="spacer"></div></td>
			<td>
				<!-- API -->
				<div class="xbtngroup">
					<button class="sexybutton" onClick="MpcEditor.xMD();MpcEditor.diaApi();return false;" id="bnApi" disabled="disabled" title="Access other product API's.">
					<span><span><span class="star">API</span></span></span></button>
				</div>
			</td>
			<td><div class="spacer"></div></td>
			<td>
				<!-- Shortcode (commercial only -->
				<div class="xbtngroup">
					<button class="sexybutton" onClick="MpcEditor.xMD();MpcEditor.diaShort();return false;" id="bnShort" disabled="disabled" title="Dynamic functions. (Commercial Mpc Only)">
					<span><span><span class="notepad">Shortcodes</span></span></span></button>
				</div>
			</td>

			<td><div class="spacer"></div></td>

			<td>
				<!-- Busy -->
                <div id="ttlbusy3" class="" style=""></div>
			<td>

			 <td style="width:90%"></td>

			 <td>
                <div id="avis_edset" style="width:104px;visibility:hidden" class="avis3" onClick="MpcEditor.xMD();MpcEditor.edset()">EDITOR SETTINGS</div>
             </td>
		  </tr>
		</table>
	</div>

<div style="position:relative">
		<textarea id="editor1" name="editor1">
		<?php echo ($iraw == 1)? '.' : $TEXTAREA ?> </textarea>

  <div id="varsdiv" <?php echo $exvars ?>>

		<table>
		  <tr>
			 <td>

				<!-- Var Special -->
				<div id="varoptdiv">
				<table><tr style="white-space:nowrap"><tr>
					<td><div class="vspe selok" id="ptag" onclick="MpcEditor.specialSelect('ptag');return false;">- Minus</div></td>
					<td><div class="vspe selok" id="ntag" onclick="MpcEditor.specialSelect('ntag');return false;">+ Plus</div></td>

					<td><div style="margin-left:7px">
				        <button class="sexybutton sexysimple sexyblack sexysmall" title="Undo last change."
				          onclick="MpcEditor.doUndo();return false;">Undo</button>
                    </div></td>

					<td><div style="margin-left:8px">
				        <button class="sexybutton sexysimple sexyblack sexysmall" title="Redo last change."
				          onclick="MpcEditor.doRedo();return false;">Redo</button>
                    </div></td>

                    <td><div id="bn_reuseDI" class="sexybutton sexysimple mpcbtn btnFull btnUnSel sexysmall" style="margin-left:15px;display:none"
                        onclick="MpcEditor.scanDI();return false;">Re-use Dynamic Includes...</div></td>
				</tr></table>
				</div>
			 </td>

		  </tr>
		  <tr>
			 <td>

				<!-- Var Options -->
				<div id="casebtndiv">
				<table><tr>
					<td><div class="vopt selok" id="opt_t" onclick="MpcEditor.optionSelect('opt_t');return false;">Title Case</div></td>
					<td><div class="vopt selok" id="opt_u" onclick="MpcEditor.optionSelect('opt_u');return false;">UPPER</div></td>
					<td><div class="vopt selok" id="opt_l" onclick="MpcEditor.optionSelect('opt_l');return false;">lower</div></td>
					<td><div class="vopt selok" id="opt_s" onclick="MpcEditor.optionSelect('opt_s');return false;">Sentence</div></td>
					<td><div class="vopt selok" id="opt_h" onclick="MpcEditor.optionSelect('opt_h');return false;">hyper-link</div></td>
					<td><div class="vopt selok" id="opt_n" onclick="MpcEditor.optionSelect('opt_n');return false;">under_score</div></td>
					<td><div class="vopt selok" id="opt_p" onclick="MpcEditor.optionSelect('opt_p');return false;">plus+sign</div></td>
					<td><div class="vopt selok" id="opt_a" onclick="MpcEditor.optionSelect('opt_a');return false;">&lt;a&gt;</div></td>
				</tr></table>
				</div>
			 </td>
		  </tr>
		</table>

		<!-- Var Select -->
		<table id="table1"><tr>
			<?php
			for($x=1;$x<10;$x++)
			{
                if(substr($ar_vbtnNames[$x-1], -1) == '.') // trailing '...' ?
                {
                    // multi-item var
                    echo '<td><div class="sexybutton sexysimple mpcbtn btnFull btnUnSel sexysmall" id="cvar'.$x.'" ';
                    echo 'onclick="MpcEditor.openMI('.$x.');return false;">'.$ar_vbtnNames[$x-1].'</div>&nbsp;&nbsp;</td>';
                }
                else
                {
                    // single item var
                    echo '<td><div class="sexybutton sexysimple mpcbtn btnFull btnUnSel sexysmall" id="cvar'.$x.'" ';
                    echo 'onclick="MpcEditor.insertVar('.$x.');return false;">'.$ar_vbtnNames[$x-1].'</div>&nbsp;&nbsp;</td>';
                }
			}
			?>
		<tr></table>
  </div>

	<div id="edittype" style="font-size:12.8px;font-weight:bold;visibility:hidden;text-align:right">
        <?php echo $editmode.': '?><span style="color:#c00000"><?php echo $saveFname ?></span>
            
        <div style="margin-top:5px;text-align:right">
            <?php echo $editlink ?>
        </div> 

        <div style="margin-top:5px;text-align:right">
            <a href="#" onclick="MpcEditor.goTop()" title="Scroll to Top">TOP</a> | <a href="#" onclick="MpcEditor.goBottom()" title="Scroll to Bottom">BOTTOM</a>
        </div> 
    </div>

	<div id="webroot" style="position:absolute;top:70px;right:10px;visibility:hidden">Editing WebRoot file</div>

</div>


		<script type="text/javascript">

				CKEDITOR.replace( 'editor1',
				{
                    extraPlugins: 'codemirror,textselection',
					height : $(window).height() - 263,
					width : '100%',
					fullPage : MpcEditor.php.jHtml,
					fillEmptyBlocks : false,
					startupFocus : false,
					removePlugins : 'resize <?php echo $exmycmenu ?>',
					enterMode : CKEDITOR.ENTER_BR,
					toolbar : 'MOST',

					on:
					{
						instanceReady : function(ev)
						{
							var tags = ['p', 'ol', 'ul', 'li', 'div'];
							for(var key in tags)
							{
								this.dataProcessor.writer.setRules(tags[key],
								{
									indent : false,
									breakBeforeOpen : false,
									breakAfterOpen : false,
									breakBeforeClose : false,
									breakAfterClose : MpcEditor.php.jHtml
								});
							}
							this.focus();
						}


					}



				});

			</script>

<input id="hidRawcode" type="hidden" value="<?php echo ($iraw == 1)? $TEXTAREA : ''; ?>" />

	</form>

<div id="bottom" style="color:<?php echo $thm_footc ?>;font-size:10px;padding:4px 2px 0;visibility:hidden;">
	<table width="100%">
		<tr>
		  <td align="center">Copyright &copy;2011-<?php echo date('Y') ?> Computerrific and Larry Sherman</td>
		</tr>
	</table>
</div>

<div id="backdiv" style="position:absolute;top:0;left:0;visibility:hidden"></div>

</div>
</div>
</body>
</html>
