<?php
require_once 'table3.php';
/*******************************************************************************
*
* Database class for Sqlite3
*
*******************************************************************************/
class dbase
{
    private $m_db;       // the sqlite3 object
    private $m_auxpath;  // '/home/user/public_html/mpc/mpc_aux'
    private $m_dbfname;  // '[bh/bt/rh/rt/xml/unbuild].db'
    private $m_dbfile;   // full loc of db file
    private $m_error;    // error message 
    private $m_varcount; // vars used (1-10)

    // hash arrays/ids
    private $m_arSrcHash = array();
    private $m_idSrcHash = 0;
    private $m_arVarHash = array();
    private $m_idVarHash = 0;

    // 'page' table binds
    private $m_pageInsert;
    private $m_idSrc; 
    private $m_sDest; 
    private $m_idCurr; 
    private $m_idPrev; 
    private $m_idNext; 
    private $m_idVar0; 
    private $m_idFilter; 
    private $m_sDestBp; 
    private $m_iSeedAs;
    private $m_iPindex;
    private $m_iSpare; // NOT USED... Always 0.
    private $m_iSiloIndex; // 0, 1-4
    private $m_flag_bits; // 0000 0001 = [front] <<< not used >>>

    // 'varset' table binds
    private $m_varsetInsert;
    private $m_varsetId = 0; 
    private $m_varsetNum; 
    private $m_varsetVarId; 

    // 'var' table binds
    private $m_varInsert;
    private $m_varId;
    private $m_varValue;

    // anchor table binds 
    private $m_anchorInsert;
    private $m_anchorRaw;
    private $m_anchorCustom;

    // 'wpitem' table binds
    private $m_wpitemInsert;
    private $m_sSrc;
    private $m_sTitle;
    private $m_sSlug;
    private $m_sCategory;
    private $m_sParent;
    private $m_sPath1;
    private $m_sSpin;

    // lastmod for xml sitemaps
    private $m_lastmod;

    // constructor
    public function __construct($auxpath, $dbfname)
    {
        $this->m_auxpath = $auxpath;
        $this->m_dbfname = $dbfname;
        $this->m_dbfile  = "$auxpath/$dbfname";
    }
   
    public function setlastmod($lastmod) {
        $this->m_lastmod = $lastmod;
    }

    public function getError() { return $this->m_error; }

    public function getVarValue($vid)
    {
        $xXcb167X9 = $this->m_db->querySingle("SELECT value FROM var WHERE id='$vid'");
        // shorten any '{xxx|xxx..}' to '{spintax}'
        return preg_replace('/\{(.+?\|.+?)+\}/', '{spintax}', $xXcb167X9);
        ////return preg_replace('/\{.+?\}/', '{spintax}', $xXcb167X9);

        //return ($xXcb167X9[0] == '{')? '{spintax}' : $xXcb167X9;
    }

    /*******************************************************************************
     *
     * Open NEW dbase for Write (open only once)
     *
     *   @Return false if error (msg in m_error)
     */
    public function openWrite($yb1d40XxF, $lowurl_yn = 0, $siloDepth = 0, $bslash = false, $banchor = false, $seed_pg = 0)
    {
        $this->m_varcount = $yb1d40XxF; // if varcount == 0, building only path table (for xml or unbuild)
        $retstat = true;
        if(file_exists($this->m_dbfile)) unlink($this->m_dbfile); // start clean
        switch($this->m_dbfname)
        {
            //--------------------------
            case 'xml.db':
            case 'unbuild.db':
            //--------------------------
                // init sqlite db
                $this->m_db = new SQLite3($this->m_dbfile);
                $this->m_db->exec('pragma synchronous = off;');
                $this->m_db->exec('BEGIN TRANSACTION;');
                yXfx2dX23($this->m_db, $this->m_varcount, $lowurl_yn, $siloDepth);
                $this->m_db->exec('COMMIT;');
                $this->m_db->exec('BEGIN TRANSACTION;');
                // 'page' prepare statements
                $this->m_pageInsert = $this->m_db->prepare("INSERT INTO page (dest) VALUES (:dest)" );
                $this->m_pageInsert->bindParam(':dest', $this->m_sDest);
                break;

            //--------------------------
            case 'bh.db':
            case 'bt.db':
            case 'rh.db':
            case 'rt.db':
            //--------------------------
                // init sqlite db
                $this->m_db = new SQLite3($this->m_dbfile);
                $this->m_db->exec('pragma synchronous = off;');
                $this->m_db->exec('BEGIN TRANSACTION;');
                yXfx2dX23($this->m_db, $this->m_varcount, $lowurl_yn, $siloDepth, $bslash, $banchor, $seed_pg);
                $this->m_db->exec('COMMIT;');
                $this->m_db->exec('BEGIN TRANSACTION;');
                // 'page' prepare statements
                $this->m_pageInsert = $this->m_db->prepare("INSERT INTO page (src, dest, curr_var, prev_var, next_var, varz_id, filter_id, dest_bp, seed_as, pindex, spare,
                silo_index, flag_bits) VALUES (:src, :dest, :curr, :prev, :next, :var0, :filter_id, :destbp, :seedas, :pindex, :spare, :siloindex, :flag_bits )");
                $this->m_pageInsert->bindParam(':src',  $this->m_idSrc);
                $this->m_pageInsert->bindParam(':dest', $this->m_sDest);
                $this->m_pageInsert->bindParam(':curr', $this->m_idCurr);
                $this->m_pageInsert->bindParam(':prev', $this->m_idPrev);
                $this->m_pageInsert->bindParam(':next', $this->m_idNext);
                $this->m_pageInsert->bindParam(':var0', $this->m_idVar0);
                $this->m_pageInsert->bindParam(':filter_id', $this->m_idFilter);
                $this->m_pageInsert->bindParam(':destbp', $this->m_sDestBp);
                $this->m_pageInsert->bindParam(':seedas', $this->m_iSeedAs);
                $this->m_pageInsert->bindParam(':pindex', $this->m_iPindex);
                $this->m_pageInsert->bindParam(':spare', $this->m_iSpare); // not used.. always zero (v607)
                $this->m_pageInsert->bindParam(':siloindex', $this->m_iSiloIndex);
                $this->m_pageInsert->bindParam(':flag_bits', $this->m_flag_bits);

                // 'varset' prepare statements
                $this->m_varsetInsert = $this->m_db->prepare("INSERT INTO varset (id, num, var_id) VALUES (:id, :num, :var_id)");
                $this->m_varsetInsert->bindParam(':id', $this->m_varsetId);   // group id
                $this->m_varsetInsert->bindParam(':num', $this->m_varsetNum); // 0-x num in group
                $this->m_varsetInsert->bindParam(':var_id', $this->m_varsetVarId); // var id
                // 'var' prepare statements
                $this->m_varInsert = $this->m_db->prepare( "INSERT INTO var (id, value) VALUES (:id, :value)" );
                $this->m_varInsert->bindParam(':id', $this->m_varId);
                $this->m_varInsert->bindParam(':value', $this->m_varValue);

                // preset var:id1 = a blank
                $this->m_varValue = '';
                $this->m_varId = ++$this->m_idVarHash;
                $this->m_arVarHash[$this->m_varValue] = $this->m_varId;
                $this->m_varInsert->execute();

                // 'anchor' prepare statements
                $this->m_anchorInsert = $this->m_db->prepare( "INSERT INTO anchor (raw, custom) VALUES (:raw, :custom)" );
                $this->m_anchorInsert->bindParam(':raw', $this->m_anchorRaw);
                $this->m_anchorInsert->bindParam(':custom', $this->m_anchorCustom);

                // 'wpitem' prepare statements
                $this->m_wpitemInsert = $this->m_db->prepare("INSERT INTO wpitem (src, title, slug, category, parent, path1, spin) VALUES (:wsrc, :wtitle, :wslug, :wcategory, :wparent, :wpath1, :wspin)");
                $this->m_wpitemInsert->bindParam(':wsrc', $this->m_sSrc);
                $this->m_wpitemInsert->bindParam(':wtitle', $this->m_sTitle);
                $this->m_wpitemInsert->bindParam(':wslug', $this->m_sSlug);
                $this->m_wpitemInsert->bindParam(':wcategory', $this->m_sCategory);
                $this->m_wpitemInsert->bindParam(':wparent', $this->m_sParent);
                $this->m_wpitemInsert->bindParam(':wpath1', $this->m_sPath1);
                $this->m_wpitemInsert->bindParam(':wspin', $this->m_sSpin);
                break;
            
            //--------------------------
            default:
            //--------------------------
                $retstat = false;
                $this->m_error = 'invalid db filename ('.$this->m_dbfname.')';
                break;
        }
        return $retstat;
    }


    /*******************************************************************************
     * xml or unbuild 'page.dest' insert
     */
    public function writeDest($sDest)
    {
        $this->m_sDest = $sDest;        
        $this->m_pageInsert->execute();
        return true;
    } 

    /*******************************************************************************
     * anchor raw,custom insert
     */
    public function writeAnchor($anchorRaw, $anchorCustom)
    {
        $this->m_anchorRaw = $anchorRaw;
        $this->m_anchorCustom = $anchorCustom;
        $this->m_anchorInsert->execute();
        return true;
    } 

    /*******************************************************************************
     * write wpitem
     *  @Parm {JSON} source, title, slug, category, parent, spin, path1
     */
    public function writeWpItem($wpi)
    {
        $ar = json_decode($wpi, true);
        $this->m_sSrc   = $ar['source'];
        $this->m_sTitle = $ar['title'];
        $this->m_sSlug  = $ar['slug'];
        $this->m_sCategory  = $ar['category'];
        $this->m_sParent = $ar['parent'];
        $this->m_sPath1  = $ar['path1'];
        $this->m_sSpin   = $ar['spin'];
        $this->m_wpitemInsert->execute();
        return true;
    } 

    /*******************************************************************************
     * 'page' table row insert (also hashes sSrc --> 'source' table)
     */
    public function writePageRow($sSrc, $sDest, $iCurr, $iPrev, $iNext, $iVar0, $iFilter, $sDestBp, $iSiloIndex, $flag_bits=0, $iSeedAs = 0, $iPindex = 0, $iSpare = 0, $vfolder = 0)
    {
        $retstat = true;
        // hash sSrc --> source table (gets id for 'page.src' table)
        if( array_key_exists($sSrc, $this->m_arSrcHash) )
        {
            $this->m_idSrc = $this->m_arSrcHash[$sSrc]; // already seen this fname.. get existing id
        }
        else
        {
            // new entry.. save hash, get new id, and insert into db
            $this->m_arSrcHash[$sSrc] = ++$this->m_idSrcHash; // store '[sSrc] = id' into hash array
            $this->m_idSrc = $this->m_idSrcHash;
            if($vfolder == 0) $fn = $this->m_auxpath.'/tmp/'.$sSrc;
            else $fn = dirname($this->m_auxpath).'/mpc_short_files/v/'.$vfolder.'/'.$sSrc;
            $this->m_db->exec( "INSERT INTO source (id, path) VALUES ('$this->m_idSrc', '$fn')" ); //
        }

        $this->m_sDest = $sDest;        
        $this->m_idCurr = $iCurr;        
        $this->m_idPrev = $iPrev;        
        $this->m_idNext = $iNext;        
        $this->m_idVar0 = $iVar0;        
        $this->m_idFilter = $iFilter;        
        $this->m_sDestBp = $sDestBp;        
        $this->m_iSeedAs = $iSeedAs;        
        $this->m_iPindex = $iPindex;
        $this->m_iSpare = $iSpare;
        $this->m_iSiloIndex = $iSiloIndex;        
        $this->m_flag_bits = $flag_bits;

        // all binding vars set.. update dbase
        $this->m_pageInsert->execute();

        return $retstat;
    }

    /*******************************************************************************
     * 'varset' table row insert (also hashes var0-10 --> 'var' table
     *   @Param String 'var0,var1,var2, .. var9'
     *
     *   @Return  id of var0 in 'var' table
     */
    public function writeVarsetRow($str10)
    {
        $xAC063X21 = explode("\t", $str10);
        $this->m_varsetId++; // 1-x
        $this->m_varsetNum = 0;

        // loop thru each var in this line
        for($x=0;$x<$this->m_varcount;$x++)
        {
            // hash var --> 'var' table (gets id for 'varset.var_id' table)
            $this->m_varValue = $xAC063X21[$x];
            if( array_key_exists($this->m_varValue, $this->m_arVarHash) )
            {
                $this->m_varId = $this->m_arVarHash[$this->m_varValue]; // var exists.. get id
            }
            else
            {
                // new var.. insert into 'var' table.. get new id
                $this->m_arVarHash[$this->m_varValue] = ++$this->m_idVarHash; // store '[var] = id' into hash array
                $this->m_varId = $this->m_idVarHash;
                $this->m_varInsert->execute();
            }
            $this->m_varsetVarId = $this->m_varId;
            $this->m_varsetInsert->execute();
            if($this->m_varsetNum == 0) $xC6E168XE = $this->m_varId;
            $this->m_varsetNum++;
        } // end loop varcount
        return $xC6E168XE;
    }

    /*******************************************************************************
     * dump page of xml sitemap lines --> file
     *   @Param Int .. first page of 1000 entries. (0-x)
     *   @Param Int ... last page of 1000 entries. (0-x)
     *   @Param String .. domain (www.domain.com/subdir/)
     *   @Param String .. dest file (will be in auxdir/tmp/) (xml.txt)
     *   @Param String .. slash_yn ('yes' or 'no')
     */
    public function dumpXmlPages($firstPage, $lastPage, $x9Ba196Xc, $file, $slash_yn, $PERPAGE = 1000)
    {
        $this->m_db = new SQLite3($this->m_dbfile); // open xml.db
        $b_slash = ($slash_yn == 'yes');
        $id1 = $firstPage * $PERPAGE;
        if($id1 == 0) $id1 = 1;
        $id2 = ($lastPage * $PERPAGE) + ($PERPAGE-1);

        if(! is_dir("$this->m_auxpath/tmp")) mkdir("$this->m_auxpath/tmp", 0777, true);
        $x6614XE05 = fopen("$this->m_auxpath/tmp/$file", 'w');

        $xXcb167X9 = $this->m_db->query("SELECT id, dest FROM page WHERE id >= '$id1' AND id <= '$id2' ORDER BY id");

        while($row = $xXcb167X9->fetchArray(SQLITE3_ASSOC))
        {
            $row_dest = $x9Ba196Xc.$row['dest'];
            if( $b_slash && (preg_match('/(.*?)(\A|\/)(index.(?:php|html|htm))$/', $row_dest, $m) == 1) )
            {
                $row_dest = $m[1].$m[2];
            }
        //    fwrite($x6614XE05, '<url><loc>'.$row_dest.'</loc></url>'."\n");
            fwrite($x6614XE05, "<url><loc>$row_dest</loc>$this->m_lastmod</url>\n");
        }
        fclose($x6614XE05);
        $this->m_db->close();
        return true;
    }

    /*******************************************************************************
     * dump all xml sitemap lines --> files
     *   @Param String .. domain (www.domain.com/subdir/)
     *   @Param String .. dest file root (will be in auxdir/tmp/)
     *   @Param String .. slash_yn ('yes' or 'no')
     *   @Param Int    .. max url lines per file
     *
     *   @Return number of files written (0-x)
     */
    public function dumpAllXmlPages($x9Ba196Xc, $file, $slash_yn, $maxlines)
    {
        $b_slash = ($slash_yn == 'yes');
        $this->m_db = new SQLite3($this->m_dbfile); // open xml.db

        $xXcb167X9 = $this->m_db->query("SELECT id, dest FROM page ORDER BY id");
        if(! is_dir("$this->m_auxpath/tmp")) mkdir("$this->m_auxpath/tmp", 0777, true);

        $files_written = 0;
        $lines_written = 0;

        while($row = $xXcb167X9->fetchArray(SQLITE3_ASSOC))
        {
            if($lines_written == 0)
            {
                // start new file
                $files_written++; // 1-x
                $x6614XE05 = fopen("$this->m_auxpath/tmp/$file$files_written", 'w'); // 'xml.txt{1-x}'
            }

            $row_dest = $x9Ba196Xc.$row['dest'];
            if( $b_slash && (preg_match('/(.*?)(\A|\/)(index.(?:php|html|htm))$/', $row_dest, $m) == 1) )
            {
                $row_dest = $m[1].$m[2];
            }

            //fwrite($x6614XE05, '<url><loc>'.$row_dest.'</loc></url>'."\n");
            fwrite($x6614XE05, "<url><loc>$row_dest</loc>$this->m_lastmod</url>\n");

            $lines_written += 2;
            if($lines_written < $maxlines) continue;
            // file maxsize.. close it
            fclose($x6614XE05);
            $lines_written = 0;
        }
        if($x6614XE05) fclose($x6614XE05);
        $this->m_db->close();
        return $files_written;
    }

    /*******************************************************************************
     * dump all unbuild lines --> file (reverse order)
     *   @Param String .. dest file (will be in auxdir/tmp/)
     */
    public function dumpUnbuild($file)
    {
        $this->m_db = new SQLite3($this->m_dbfile); // open unbuild.db

        $xXcb167X9 = $this->m_db->query("SELECT dest FROM page ORDER BY id DESC");
        if(! is_dir("$this->m_auxpath/tmp")) mkdir("$this->m_auxpath/tmp", 0777, true);
        $x6614XE05 = fopen("$this->m_auxpath/tmp/$file", 'w');

        while($row = $xXcb167X9->fetchArray(SQLITE3_ASSOC))
        {
            fwrite($x6614XE05, $row['dest']."\n");
        }
        fclose($x6614XE05);
        $this->m_db->close();
        return true;
    }

    /*******************************************************************************
     * dump page of blueprint lines --> file (for viewer)
     *   @Param Int .. first page of 1000 entries. (0-x)
     *   @Param Int ... last page of 1000 entries. (0-x)
     *   @Param String .. dest file (will be in auxdir/tmp/) (bx.txt)
     *
     *   @Return JSON ..
     *            varcount:
     *            iLegend: (has silo or file ext?)
     */
    public function dumpBpPagesH($firstPage, $lastPage, $file, $PERPAGE = 1000)
    {
        $this->m_db = new SQLite3($this->m_dbfile); // open [Blueprint] database

        $id1 = $firstPage * $PERPAGE;
        if($id1 == 0) $id1 = 1;
        $id2 = ($lastPage * $PERPAGE) + ($PERPAGE-1);

        if(! is_dir("$this->m_auxpath/tmp")) mkdir("$this->m_auxpath/tmp", 0777, true);
        $x6614XE05 = fopen("$this->m_auxpath/tmp/$file", 'w');

        $result_psd = $this->m_db->query("SELECT id, dest_bp, curr_var FROM page WHERE id >= '$id1' AND id <= '$id2' ORDER BY id");
        $iLegend = 0;
        while($row_psd = $result_psd->fetchArray(SQLITE3_ASSOC))
        {
            $fline = $row_psd['dest_bp'];
            if( (strpos($fline, '//') !== false) || (substr($fline, -2) == '_#') ) $iLegend = 1;
            $result_vid = $this->m_db->query("SELECT var_id FROM varset WHERE id='$row_psd[id]' ORDER BY num"); // var_id
            while($row_vid = $result_vid->fetchArray(SQLITE3_ASSOC))
            {
                $fline .= "\t".$row_vid['var_id'];
            }                
            fwrite($x6614XE05, "$fline\n");
        }
        fclose($x6614XE05);

        $xXcb167X9 = $this->m_db->query("SELECT varcount FROM info");
        $row = $xXcb167X9->fetchArray(SQLITE3_ASSOC);
        $vc = $row['varcount'];
        return '{"varcount":'.$vc.',"iLegend":'.$iLegend.'}';
    }

    /*******************************************************************************
     * dump page of blueprint lines --> file (for viewer)
     *   @Param Int .. first page of 1000 entries. (0-x)
     *   @Param Int ... last page of 1000 entries. (0-x)
     *   @Param String .. dest file (will be in auxdir/tmp/) (bx.txt)
     *
     *   @Return JSON ..
     *            varcount:
     *            iLegend: 0
     */
    public function dumpBpPagesT($firstPage, $lastPage, $file, $PERPAGE = 1000)
    {
        $this->m_db = new SQLite3($this->m_dbfile); // open [Blueprint] database

        $id1 = $firstPage * $PERPAGE;
        if($id1 == 0) $id1 = 1;
        $id2 = ($lastPage * $PERPAGE) + ($PERPAGE-1);

        if(! is_dir("$this->m_auxpath/tmp")) mkdir("$this->m_auxpath/tmp", 0777, true);
        $x6614XE05 = fopen("$this->m_auxpath/tmp/$file", 'w');

        $result_wpi = $this->m_db->query("SELECT id, src, title, slug, spin, category, parent, path1 FROM wpitem WHERE id >= '$id1' AND id <= '$id2' ORDER BY id");

        while($row_wpi = $result_wpi->fetchArray(SQLITE3_ASSOC))
        {
            // WAS: src - title - slug - spin - vars
            // NOW: src - title - slug - spin - category - parent - path1 - vars
            $fline = $row_wpi['src']."\t".$row_wpi['title']."\t".$row_wpi['slug']."\t".$row_wpi['spin']."\t".$row_wpi['category']."\t".$row_wpi['parent']."\t".$row_wpi['path1'];
            $result_vid = $this->m_db->query("SELECT var_id FROM varset WHERE id='$row_wpi[id]' ORDER BY num"); // var_id
            while($row_vid = $result_vid->fetchArray(SQLITE3_ASSOC))
            {
                $fline .= "\t".$row_vid['var_id'];
            }                
            fwrite($x6614XE05, "$fline\n");
        }
        fclose($x6614XE05);

        $xXcb167X9 = $this->m_db->query("SELECT varcount FROM info");
        $row = $xXcb167X9->fetchArray(SQLITE3_ASSOC);
        $vc = $row['varcount'];
        return '{"varcount":'.$vc.',"iLegend":0}';
    }

    /*******************************************************************************
     * do a query
     *
     */
    public function doQuery($xaFD162Xd)
    {
        $this->m_db->exec($xaFD162Xd);
        return true;
    }

    /*******************************************************************************
     * close the sqlite3 dbase
     */
    public function close($bCommit = false)
    {
        if(isset($this->m_db))
        {
            if($bCommit) $this->m_db->exec('COMMIT;');
            $this->m_db->close();
        }
    }
/*
    private function DEBUGDB($msg,$file = './DEBUGDB') {
        $xcf35XCFE = fopen($file,'ab');
        fwrite($xcf35XCFE,$msg,strlen($msg));
        fwrite($xcf35XCFE,"\n",1);
        fclose($xcf35XCFE);
    }

    function ARDEBUG($msg,$xAC063X21,$file = './DEBUGDB') {
        $msg .= "\n".print_r($xAC063X21,true);
        $xcf35XCFE = fopen($file,'ab');
        fwrite($xcf35XCFE,$msg,strlen($msg));
        fwrite($xcf35XCFE,"\n",1);
        fclose($xcf35XCFE);
    }
*/
}
?>
